# == Class: vmms::api
#
# Installs & configure the VMMS API service
#
# === Parameters
#
# [*enabled*]
#   (optional) Should the service be enabled.
#   Defaults to 'true'.
#
# [*manage_service*]
#   (optional) Whether the service should be managed by Puppet.
#   Defaults to 'true'.
#
# [*package_ensure*]
#    (Optional) Ensure state for package.
#    Defaults to present
#
# [*service_name*]
#   (optional) Name of the service that will be providing the
#   server functionality of vmms-api.
#   Defaults to '$::vmms::params::api_service_name'
#
class vmms::api (
  Boolean $enabled                 = true,
  Boolean $manage_service          = true,
  $package_ensure                  = present,
  $service_name                    = $::vmms::params::api_service_name,
) inherits vmms::params {

  include vmms::deps
  include vmms::params

  package { 'vmms-api':
    ensure => $package_ensure,
    name   => $::vmms::params::api_package_name,
    tag    => ['openstack', 'vmms-package'],
  }

  if $manage_service {
    if $enabled {
      $service_ensure = 'running'
    } else {
      $service_ensure = 'stopped'
    }

    if $service_name == $::vmms::params::api_service_name {
      service { 'vmms-api':
        ensure     => $service_ensure,
        name       => $::vmms::params::api_service_name,
        enable     => $enabled,
        hasstatus  => true,
        hasrestart => true,
        tag        => 'vmms-service',
      }
    } else {
      fail("Invalid service_name. Either vmms/openstack-vmms-api for running \
 as a standalone service, or httpd for being run by a httpd server")
    }
  }
}
