# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storagemover.aio import StorageMoverMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageMoverMgmtAgentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageMoverMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_agents_get(self, resource_group):
        response = await self.client.agents.get(
            resource_group_name=resource_group.name,
            storage_mover_name="str",
            agent_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_agents_create_or_update(self, resource_group):
        response = await self.client.agents.create_or_update(
            resource_group_name=resource_group.name,
            storage_mover_name="str",
            agent_name="str",
            agent={
                "properties": {
                    "arcResourceId": "str",
                    "arcVmUuid": "str",
                    "agentStatus": "str",
                    "agentVersion": "str",
                    "description": "str",
                    "errorDetails": {"code": "str", "message": "str"},
                    "lastStatusUpdate": "2020-02-20 00:00:00",
                    "localIPAddress": "str",
                    "memoryInMB": 0,
                    "numberOfCores": 0,
                    "provisioningState": "str",
                    "timeZone": "str",
                    "uploadLimitSchedule": {
                        "weeklyRecurrences": [
                            {
                                "days": ["str"],
                                "endTime": {"hour": 0, "minute": 0},
                                "limitInMbps": 0,
                                "startTime": {"hour": 0, "minute": 0},
                            }
                        ]
                    },
                    "uptimeInSeconds": 0,
                },
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_agents_update(self, resource_group):
        response = await self.client.agents.update(
            resource_group_name=resource_group.name,
            storage_mover_name="str",
            agent_name="str",
            agent={
                "properties": {
                    "description": "str",
                    "uploadLimitSchedule": {
                        "weeklyRecurrences": [
                            {
                                "days": ["str"],
                                "endTime": {"hour": 0, "minute": 0},
                                "limitInMbps": 0,
                                "startTime": {"hour": 0, "minute": 0},
                            }
                        ]
                    },
                }
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_agents_begin_delete(self, resource_group):
        response = await (
            await self.client.agents.begin_delete(
                resource_group_name=resource_group.name,
                storage_mover_name="str",
                agent_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_agents_list(self, resource_group):
        response = self.client.agents.list(
            resource_group_name=resource_group.name,
            storage_mover_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
