% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{dir_ls}
\alias{dir_ls}
\alias{dir_map}
\alias{dir_walk}
\alias{dir_info}
\title{List files}
\usage{
dir_ls(
  path = ".",
  all = FALSE,
  recurse = FALSE,
  type = "any",
  glob = NULL,
  regexp = NULL,
  invert = FALSE,
  fail = TRUE,
  ...,
  recursive
)

dir_map(
  path = ".",
  fun,
  all = FALSE,
  recurse = FALSE,
  type = "any",
  fail = TRUE
)

dir_walk(
  path = ".",
  fun,
  all = FALSE,
  recurse = FALSE,
  type = "any",
  fail = TRUE
)

dir_info(
  path = ".",
  all = FALSE,
  recurse = FALSE,
  type = "any",
  regexp = NULL,
  glob = NULL,
  fail = TRUE,
  ...
)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{all}{If \code{TRUE} hidden files are also returned.}

\item{recurse}{If \code{TRUE} recurse fully, if a positive number the number of levels
to recurse.}

\item{type}{File type(s) to return, one or more of "any", "file", "directory",
"symlink", "FIFO", "socket", "character_device" or "block_device".}

\item{glob}{A wildcard aka globbing pattern (e.g. \verb{*.csv}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{regexp}{A regular expression (e.g. \verb{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{fail}{Should the call fail (the default) or warn if a file cannot be
accessed.}

\item{...}{Additional arguments passed to \link{grep}.}

\item{recursive}{(Deprecated) If \code{TRUE} recurse fully.}

\item{fun}{A function, taking one parameter, the current path entry.}
}
\description{
\code{dir_ls()} is equivalent to the \code{ls} command. It returns filenames as a
named \code{fs_path} character vector. The names are equivalent to the values,
which is useful for passing onto functions like \code{purrr::map_dfr()}.

\code{dir_info()} is equivalent to \code{ls -l} and a shortcut for
\code{file_info(dir_ls())}.

\code{dir_map()} applies a function \code{fun()} to each entry in the path and returns
the result in a list.

\code{dir_walk()} calls \code{fun} for its side-effect and returns the input \code{path}.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
dir_ls(R.home("share"), type = "directory")

# Create a shorter link
link_create(system.file(package = "base"), "base")

dir_ls("base", recurse = TRUE, glob = "*.R")

# If you need the full paths input an absolute path
dir_ls(path_abs("base"))

dir_map("base", identity)

dir_walk("base", str)

dir_info("base")

# Cleanup
link_delete("base")
\dontshow{setwd(.old_wd)}
}
