// Copyright (C) 2016 EDF
// All Rights Reserved
// This code is published under the GNU Lesser General Public License (GNU LGPL)
#ifndef  EIGENCOMPARISON_H
#define EIGENCOMPARISON_H
#include <cmath>
#include <vector>
#include <Eigen/Dense>

/** \file eigenComparisx1on.h
 *  \brief Provide comparison stuff for Eigen
 *  \author Pierre Gruet
 */

namespace StOpt
{
/// \brief comparator for maps with key being vector<ArrayXi>
struct cmpVectorArrayXi {
    bool operator()(std::vector<Eigen::ArrayXi> const& a, std::vector<Eigen::ArrayXi> const& b) const
    {
        std::vector<Eigen::ArrayXi>::const_iterator itA = a.cbegin();
        std::vector<Eigen::ArrayXi>::const_iterator itB = b.cbegin();

        // Comparing pairs of ArrayXi of the first and second vector.
        for ( ; (itA != a.cend()) && (itB != b.cend()) ; ++itA, (void) ++itB)
        {
            size_t iArray = 0;

            // Comparing pairs of integers of the first and second ArrayXi.
            for ( ; (iArray != itA->size()) && (iArray != itB->size()) ; (void) ++iArray)
            {
                if ((*itA)(iArray) < (*itB)(iArray))
                    return true;
                if ((*itA)(iArray) > (*itB)(iArray))
                    return false;
            }

            // If all elements were equal up to now, return true or false if one of the ArrayXi is shorter.
            if (itA->size() != itB->size())
                return (iArray == itA->size()) && (iArray < itB->size());
        }

        // If all ArrayXi in the vectors were equal up to now, return true or false if one of the vectors is shorter.
        return (itA == a.cend()) && (itB != b.cend());
    }
};

/// \brief test equality of two vector<ArrayXi>
 bool vectorArrayXiEq(std::vector<Eigen::ArrayXi> const& a, std::vector<Eigen::ArrayXi> const& b);

}
#endif /* EIGENCOMPARISON_H */
