---
title: 0.251.0 Breaking Changes
slug: breaking-changes/0.251.0
---

# v0.251.0 Breaking Changes

We slightly changed the signature of the `encode_json` method used to customize
the JSON encoder used by our HTTP views.

Originally, the method was only meant to encode HTTP response data. Starting
with this release, it's also used to encode WebSocket messages.

Previously, the method signature was:

```python
def encode_json(self, response_data: GraphQLHTTPResponse) -> str: ...
```

To upgrade your code, change the method signature to the following and make sure
your method can handle the same inputs as the built-in `json.dumps` method:

```python
def encode_json(self, data: object) -> str: ...
```
