/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class KeywordMap<V> {
    private final Map<String, V> valueMap = new LinkedHashMap<String, V>();
    private final Map<String, String> aliasMap = new HashMap<String, String>();
    private static final String AMBIGUOUS = "";

    private static String normalizeKeyword(String string) {
        return string.toLowerCase();
    }

    private final void addAliases(String string) {
        String string2 = string;
        while (!(string2 = string2.substring(0, string2.length() - 1)).isEmpty()) {
            String string3 = this.aliasMap.get(string2);
            if (string3 == null) {
                this.aliasMap.put(string2, string);
                continue;
            }
            if (string3 == AMBIGUOUS) break;
            this.aliasMap.put(string2, AMBIGUOUS);
        }
    }

    public KeywordMap<V> put(String string, V v) {
        string = KeywordMap.normalizeKeyword(string);
        this.valueMap.put(string, v);
        this.addAliases(string);
        return this;
    }

    public final V get(String string) {
        V v = this.valueMap.get(string = KeywordMap.normalizeKeyword(string));
        if (v != null) {
            return v;
        }
        if ((string = this.aliasMap.get(string)) == null) {
            return null;
        }
        if (string == AMBIGUOUS) {
            return null;
        }
        return this.valueMap.get(string);
    }

    public final String[] getKeywords() {
        Set<String> set = this.valueMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public final boolean isEmpty() {
        return this.valueMap.isEmpty();
    }
}

