/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.reader.UniversalProjectReader;
import net.sf.mpxj.utility.clean.CleanByRedactStrategy;
import net.sf.mpxj.utility.clean.CleanByReplacementStrategy;
import net.sf.mpxj.utility.clean.CleanStrategy;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ProjectCleanUtility {
    private CleanStrategy m_strategy;
    private ProjectFile m_project;
    private static final ProjectField[] PROJECT_FIELDS = new ProjectField[]{ProjectField.AUTHOR, ProjectField.SUBJECT, ProjectField.COMPANY, ProjectField.PROJECT_TITLE, ProjectField.KEYWORDS, ProjectField.COMMENTS, ProjectField.LAST_AUTHOR, ProjectField.MANAGER, ProjectField.CATEGORY};
    private static final TaskField[] TASK_FIELDS = new TaskField[]{TaskField.NAME};
    private static final ResourceField[] RESOURCE_FIELDS = new ResourceField[]{ResourceField.NAME, ResourceField.INITIALS};

    public static void main(String[] args) {
        try {
            if (args.length < 2 || args.length > 3) {
                System.out.println("Usage: ProjectCleanUtility [redact] <input file name> <output file name>");
            } else {
                String outputFile;
                String inputFile;
                CleanStrategy strategy;
                if (args.length == 2) {
                    strategy = new CleanByReplacementStrategy();
                    inputFile = args[0];
                    outputFile = args[1];
                } else {
                    strategy = args[0].equalsIgnoreCase("redact") ? new CleanByRedactStrategy() : new CleanByReplacementStrategy();
                    inputFile = args[1];
                    outputFile = args[2];
                }
                System.out.println("Clean started.");
                long start = System.currentTimeMillis();
                ProjectCleanUtility clean = new ProjectCleanUtility();
                clean.process(strategy, inputFile, outputFile);
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("Clean completed in " + elapsed + "ms");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void process(String input, String output) throws MPXJException, IOException {
        this.process(new CleanByReplacementStrategy(), input, output);
    }

    public void process(CleanStrategy strategy, String input, String output) throws MPXJException, IOException {
        this.m_strategy = strategy;
        this.m_project = new UniversalProjectReader().read(input);
        if (this.m_project.getProjectProperties().getFileType().equals("MPP")) {
            this.processMPP(input, output);
        } else {
            this.processFile(input, output);
        }
    }

    private void processFile(String input, String output) throws IOException {
        FileInputStream is = new FileInputStream(input);
        byte[] data = InputStreamHelper.read((InputStream)is, is.available());
        is.close();
        this.processReplacements(data, Collections.singletonList(this.m_project.getProjectProperties()), false, false, PROJECT_FIELDS);
        this.processReplacements(data, this.m_project.getTasks(), false, false, TASK_FIELDS);
        this.processReplacements(data, this.m_project.getResources(), false, false, RESOURCE_FIELDS);
        FileOutputStream os = new FileOutputStream(output);
        os.write(data);
        os.flush();
        os.close();
    }

    private void processMPP(String input, String output) throws IOException {
        String varDataFileName;
        String projectDirName;
        int mppFileType = NumberHelper.getInt(this.m_project.getProjectProperties().getMppFileType());
        switch (mppFileType) {
            case 8: {
                projectDirName = "   1";
                varDataFileName = "FixDeferFix   0";
                break;
            }
            case 9: {
                projectDirName = "   19";
                varDataFileName = "Var2Data";
                break;
            }
            case 12: {
                projectDirName = "   112";
                varDataFileName = "Var2Data";
                break;
            }
            case 14: {
                projectDirName = "   114";
                varDataFileName = "Var2Data";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported file type " + mppFileType);
            }
        }
        FileInputStream is = new FileInputStream(input);
        POIFSFileSystem fs = new POIFSFileSystem(is);
        is.close();
        DirectoryNode root = fs.getRoot();
        DirectoryEntry projectDir = (DirectoryEntry)root.getEntry(projectDirName);
        this.processFile((DirectoryEntry)projectDir.getEntry("TBkndTask"), varDataFileName, this.m_project.getTasks(), true, TaskField.NAME);
        this.processFile((DirectoryEntry)projectDir.getEntry("TBkndRsc"), varDataFileName, this.m_project.getResources(), true, ResourceField.NAME, ResourceField.INITIALS);
        List<ProjectProperties> projectProperties = Collections.singletonList(this.m_project.getProjectProperties());
        this.processFile(projectDir, "Props", projectProperties, true, PROJECT_FIELDS);
        this.processFile(root, "\u0005SummaryInformation", projectProperties, false, PROJECT_FIELDS);
        this.processFile(root, "\u0005DocumentSummaryInformation", projectProperties, false, PROJECT_FIELDS);
        FileOutputStream os = new FileOutputStream(output);
        fs.writeFilesystem(os);
        os.flush();
        os.close();
        fs.close();
    }

    private void processReplacements(byte[] data, List<? extends FieldContainer> items, boolean unicode, boolean nulTerminated, FieldType ... fields) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (FieldContainer fieldContainer : items) {
            for (FieldType field : fields) {
                String oldText = (String)fieldContainer.getCachedValue(field);
                if (oldText == null || oldText.length() <= 1 || replacements.containsKey(oldText)) continue;
                replacements.put(oldText, this.m_strategy.generateReplacementText(oldText));
            }
        }
        ArrayList keys = new ArrayList(replacements.keySet());
        keys.sort((o1, o2) -> o2.length() - o1.length());
        for (String findText : keys) {
            String replaceText = (String)replacements.get(findText);
            this.replaceData(data, findText, replaceText, unicode, nulTerminated);
        }
    }

    private byte[] extractFile(DirectoryEntry parentDirectory, String fileName) throws IOException {
        DocumentEntry targetFile = (DocumentEntry)parentDirectory.getEntry(fileName);
        DocumentInputStream dis = new DocumentInputStream(targetFile);
        int dataSize = dis.available();
        byte[] data = InputStreamHelper.read((InputStream)dis, dataSize);
        dis.close();
        targetFile.delete();
        return data;
    }

    private void processFile(DirectoryEntry parentDirectory, String fileName, List<? extends FieldContainer> items, boolean unicode, FieldType ... fields) throws IOException {
        byte[] data = this.extractFile(parentDirectory, fileName);
        this.processReplacements(data, items, unicode, true, fields);
        parentDirectory.createDocument(fileName, new ByteArrayInputStream(data));
    }

    private void replaceData(byte[] data, String findText, String replaceText, boolean unicode, boolean nulTerminated) {
        boolean replaced = false;
        byte[] findBytes = this.getBytes(findText, unicode, nulTerminated);
        byte[] replaceBytes = this.getBytes(replaceText, unicode, nulTerminated);
        int endIndex = data.length - findBytes.length;
        for (int index = 0; index <= endIndex; ++index) {
            if (!this.compareBytes(findBytes, data, index)) continue;
            System.arraycopy(replaceBytes, 0, data, index, replaceBytes.length);
            index += replaceBytes.length;
            System.out.println(findText + " -> " + replaceText);
            replaced = true;
        }
        if (!replaced) {
            System.out.println("Failed to find " + findText);
        }
    }

    private byte[] getBytes(String value, boolean unicode, boolean nulTerminated) {
        byte[] result;
        if (unicode) {
            int start = 0;
            byte[] bytes = value.getBytes(CharsetHelper.UTF16);
            if (bytes.length > 2 && bytes[0] == -2 && bytes[1] == -1) {
                start = 2;
            }
            result = new byte[bytes.length - start];
            for (int loop = start; loop < bytes.length - 1; loop += 2) {
                result[loop - start] = bytes[loop + 1];
                result[loop + 1 - start] = bytes[loop];
            }
        } else {
            int length = nulTerminated ? value.length() + 1 : value.length();
            result = new byte[length];
            System.arraycopy(value.getBytes(), 0, result, 0, value.length());
        }
        return result;
    }

    private boolean compareBytes(byte[] lhs, byte[] rhs, int rhsOffset) {
        boolean result = true;
        for (int loop = 0; loop < lhs.length; ++loop) {
            if (lhs[loop] == rhs[rhsOffset + loop]) continue;
            result = false;
            break;
        }
        return result;
    }
}

