/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.utils.CommonUtils;

public class SQLWordPartDetector
extends SQLIdentifierDetector {
    private String prevKeyWord = "";
    private String prevDelimiter = null;
    private List<String> prevWords = null;
    private String nextWord;
    private String wordPart;
    private String fullWord;
    private int cursorOffset;
    private int startOffset;
    private int endOffset;
    private int delimiterOffset;
    private int prevKeyWordOffset = -1;

    public SQLWordPartDetector(IDocument document, SQLSyntaxManager syntaxManager, int documentOffset) {
        this(document, syntaxManager, documentOffset, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLWordPartDetector(IDocument document, SQLSyntaxManager syntaxManager, int documentOffset, int prevWordsParse) {
        super(syntaxManager.getDialect(), syntaxManager.getStructSeparator(), syntaxManager.getIdentifierQuoteStrings());
        this.cursorOffset = documentOffset;
        this.startOffset = documentOffset - 1;
        this.endOffset = documentOffset;
        int topIndex = 0;
        int documentLength = document.getLength();
        try {
            char ch;
            int nextOffset;
            char ch2;
            String contentType = TextUtilities.getContentType((IDocument)document, (String)"___sql_partitioning", (int)documentOffset, (boolean)true);
            boolean inQuote = "sql_quoted".equals(contentType);
            boolean inString = "sql_character".equals(contentType);
            while (this.startOffset >= topIndex && this.startOffset < documentLength) {
                char c = document.getChar(this.startOffset);
                if (inQuote || inString) {
                    block26: {
                        if (this.isQuote(c)) {
                            if (this.startOffset > 1 && syntaxManager.getStructSeparator() == document.getChar(this.startOffset - 1)) {
                                --this.startOffset;
                                inQuote = false;
                                break block26;
                            } else {
                                --this.startOffset;
                                break;
                            }
                        }
                        if (this.isStringQuote(c)) break;
                    }
                    --this.startOffset;
                    continue;
                }
                if (this.isQuote(c)) {
                    --this.startOffset;
                    inQuote = true;
                    continue;
                }
                if (this.isStringQuote(c)) {
                    --this.startOffset;
                    inString = true;
                    continue;
                }
                if (!this.isWordPart(c)) break;
                --this.startOffset;
            }
            while (this.endOffset < documentLength && this.isWordPart(document.getChar(this.endOffset))) {
                ++this.endOffset;
            }
            this.wordPart = document.get(this.startOffset, documentOffset - this.startOffset);
            this.fullWord = document.get(this.startOffset, this.endOffset - this.startOffset);
            for (int prevOffset = this.startOffset++; prevOffset >= topIndex; --prevOffset) {
                String prevWord;
                StringBuilder prevPiece = new StringBuilder();
                while (prevOffset >= topIndex && !this.isWordPart(ch2 = document.getChar(prevOffset))) {
                    if (!Character.isWhitespace(ch2)) {
                        this.delimiterOffset = prevOffset;
                    }
                    prevPiece.insert(0, ch2);
                    --prevOffset;
                }
                if (this.prevDelimiter == null) {
                    this.prevDelimiter = prevPiece.toString().trim();
                }
                for (String delim : syntaxManager.getStatementDelimiters()) {
                    if (prevPiece.indexOf(delim) == -1) continue;
                    return;
                }
                inQuote = false;
                int prevStartOffset = prevOffset + 1;
                while (prevOffset >= topIndex) {
                    char ch3 = document.getChar(prevOffset);
                    if (this.isQuote(ch3)) {
                        inQuote = !inQuote;
                        --prevOffset;
                        continue;
                    }
                    if (inQuote || this.isWordPart(ch3)) {
                        --prevOffset;
                        continue;
                    }
                    ++prevOffset;
                    break;
                }
                if (prevOffset < topIndex) {
                    prevOffset = topIndex;
                }
                if (this.dialect.isEntityQueryWord(prevWord = document.get(prevOffset, prevStartOffset - prevOffset)) || this.dialect.isAttributeQueryWord(prevWord) || SQLUtils.isExecKeyword((SQLDialect)this.dialect, (String)prevWord)) {
                    if (CommonUtils.isEmpty((String)this.prevKeyWord)) {
                        this.prevKeyWord = prevWord.toUpperCase(Locale.ENGLISH);
                        this.prevKeyWordOffset = prevOffset;
                        if (prevWordsParse <= 1) {
                            break;
                        }
                    } else if (this.prevWords != null && this.prevWords.size() >= prevWordsParse) break;
                }
                if (this.prevWords == null) {
                    this.prevWords = new ArrayList<String>();
                }
                if (prevWord.equals(this.prevKeyWord)) continue;
                this.prevWords.add(prevWord);
            }
            for (nextOffset = documentOffset; nextOffset < documentLength && !this.isWordPart(ch2 = document.getChar(nextOffset)); ++nextOffset) {
            }
            int wordPos = nextOffset;
            while (nextOffset < documentLength && this.isWordPart(ch = document.getChar(nextOffset))) {
                ++nextOffset;
            }
            if (nextOffset <= wordPos) return;
            this.nextWord = document.get(wordPos, nextOffset - wordPos);
            return;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getWordPart() {
        return this.wordPart;
    }

    public String getFullWord() {
        return this.fullWord;
    }

    public String getPrevDelimiter() {
        return this.prevDelimiter;
    }

    public List<String> getPrevWords() {
        return this.prevWords;
    }

    public int getCursorOffset() {
        return this.cursorOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLength() {
        return this.endOffset - this.startOffset;
    }

    public String getPrevKeyWord() {
        return this.prevKeyWord;
    }

    public int getPrevKeyWordOffset() {
        return this.prevKeyWordOffset;
    }

    public String getNextWord() {
        return this.nextWord;
    }

    public String[] splitWordPart() {
        return super.splitIdentifier(this.wordPart);
    }

    public void moveToDelimiter() {
        int shift = this.startOffset - this.delimiterOffset;
        this.startOffset -= shift;
    }

    public void shiftOffset(int offset) {
        this.startOffset += offset;
    }
}

