/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class HANADependency
implements DBSObject {
    private DBSObject dependentObject;
    private String baseObjectType;
    private String baseObjectSchema;
    private String baseObjectName;

    public HANADependency(DBSObject dependentObject, String baseObjectType, String baseObjectSchema, String baseObjectName) {
        this.dependentObject = dependentObject;
        this.baseObjectType = baseObjectType;
        this.baseObjectSchema = baseObjectSchema;
        this.baseObjectName = baseObjectName;
    }

    @NotNull
    public String getName() {
        return DBUtils.getFullyQualifiedName((DBPDataSource)this.dependentObject.getDataSource(), (String[])new String[]{this.baseObjectSchema, this.baseObjectName});
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBSObject getParentObject() {
        return this.dependentObject.getParentObject();
    }

    public DBPDataSource getDataSource() {
        return this.dependentObject.getDataSource();
    }

    @Property(viewable=true, order=20)
    public String getBaseObjectType() {
        return this.baseObjectType;
    }

    @Property(viewable=true, order=21)
    public DBSObject getBaseObjectSchema(DBRProgressMonitor monitor) throws DBException {
        Object schema = ((GenericDataSource)this.dependentObject.getDataSource()).getSchema(this.baseObjectSchema);
        if (schema == null) {
            schema = new DummyObject(this, this.baseObjectSchema);
        }
        return schema;
    }

    @Property(viewable=true, order=22)
    public DBSObject getBaseObject(DBRProgressMonitor monitor) throws DBException {
        GenericSchema schema = ((GenericDataSource)this.dependentObject.getDataSource()).getSchema(this.baseObjectSchema);
        DummyObject object = null;
        if (schema != null) {
            switch (this.baseObjectType) {
                case "TABLE": 
                case "VIEW": {
                    object = schema.getTable(monitor, this.baseObjectName);
                    break;
                }
                case "SYNONYM": {
                    object = (DBSObject)DBUtils.findObject((Collection)schema.getSynonyms(monitor), (String)this.baseObjectName);
                    break;
                }
                case "PROCEDURE": 
                case "FUNCTION": {
                    object = schema.getProcedure(monitor, this.baseObjectName);
                    break;
                }
                default: {
                    object = schema.getChild(monitor, this.baseObjectName);
                }
            }
        }
        if (object == null) {
            object = new DummyObject(this, this.baseObjectName);
        }
        return object;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<HANADependency> readDependencies(DBRProgressMonitor monitor, DBSObject object) throws DBException {
        ArrayList<HANADependency> dependencies = new ArrayList<HANADependency>();
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)object.getDataSource(), (String)"Read dependencies");){
            ArrayList<HANADependency> arrayList;
            block22: {
                JDBCPreparedStatement dbStat = session.prepareStatement("SELECT BASE_OBJECT_TYPE, BASE_SCHEMA_NAME, BASE_OBJECT_NAME FROM SYS.OBJECT_DEPENDENCIES WHERE DEPENDENT_SCHEMA_NAME = ? AND DEPENDENT_OBJECT_NAME = ? ORDER BY BASE_SCHEMA_NAME, BASE_OBJECT_NAME");
                try {
                    dbStat.setString(1, object.getParentObject().getName());
                    dbStat.setString(2, object.getName());
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String baseObjectType = dbResult.getString(1);
                            String baseObjectSchema = dbResult.getString(2);
                            String baseObjectName = dbResult.getString(3);
                            HANADependency dependency = new HANADependency(object, baseObjectType, baseObjectSchema, baseObjectName);
                            dependencies.add(dependency);
                        }
                    }
                    arrayList = dependencies;
                    if (dbStat == null) break block22;
                }
                catch (Throwable throwable) {
                    if (dbStat != null) {
                        try {
                            dbStat.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbStat.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, object.getDataSource());
        }
    }

    class DummyObject
    implements DBSObject {
        private String name;

        DummyObject(HANADependency this$0, String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return null;
        }

        public boolean isPersisted() {
            return false;
        }

        public DBSObject getParentObject() {
            return null;
        }

        public DBPDataSource getDataSource() {
            return null;
        }
    }
}

