define(["./../dom.js"],function(_dom){var kbdProps="altKey,ctrlKey,metaKey,shiftKey".split(","),ptProps="pageX,pageY,clientX,clientY,screenX,screenY".split(",");function DragDrop(){this._boundPointerMove=this._PointerMove.bind(this),this._boundPointerUp=this._PointerUp.bind(this),this._boundContextMenu=this._contextMenu.bind(this),_dom.default.addEventListener(document,window.PointerEvent?"pointerdown":"touchstart",this._pointerDown.bind(this),{passive:!0})}function shouldHandle(e){return e.defaultPrevented||(e=e.touches)&&2<e.length?void 0:1}function getPoint(e,page){var touches=e.touches;return touches&&touches.length&&(e=touches[0]),{x:page?e.pageX:e.clientX,y:page?e.pageY:e.clientY}}function removeImage(instance,img,dragSource,lastPointerEvent){img.remove(),dragSource&&dispatchEvent(instance,lastPointerEvent,"dragendcomplete",dragSource,getPoint(lastPointerEvent))}function copyProps(dst,src,props){for(var i=0;i<props.length;i++){var p=props[i];dst[p]=src[p]}}function dispatchEvent(instance,e,type,target,pt){var evt,t;if(e&&target)return evt=document.createEvent("Event"),t=e.touches?e.touches[0]:e,evt.initEvent(type,!0,!0),evt.button=0,evt.which=evt.buttons=1,evt.detail={polyfill:!0,dragX:instance._dragX,dragY:instance._dragY,pt:pt,ptDown:instance._ptDown},copyProps(evt,e,kbdProps),copyProps(evt,t,ptProps),type=(type=instance._dataTransfer)||(instance._dataTransfer=new DataTransfer),evt.dataTransfer=type,target.dispatchEvent(evt),evt.defaultPrevented}DragDrop.prototype.addAdditionalEventListeners=function(){this._devicePixelRatio=window.devicePixelRatio||1,_dom.default.addEventListener(document,"pointermove",this._boundPointerMove,{passive:!1,capture:!1}),_dom.default.addEventListener(document,"touchmove",this._boundPointerMove,{passive:!1,capture:!1}),window.PointerEvent?(_dom.default.addEventListener(document,"pointerup",this._boundPointerUp,{passive:!0}),_dom.default.addEventListener(document,"pointercancel",this._boundPointerUp,{passive:!0})):_dom.default.addEventListener(document,"touchend",this._boundPointerUp,{passive:!0}),_dom.default.addEventListener(document,"contextmenu",this._boundContextMenu,{passive:!0})},DragDrop.prototype.removeAdditionalEventListeners=function(){_dom.default.removeEventListener(document,"pointermove",this._boundPointerMove,{passive:!1,capture:!1}),_dom.default.removeEventListener(document,"touchmove",this._boundPointerMove,{passive:!1,capture:!1}),_dom.default.removeEventListener(document,"pointerup",this._boundPointerUp,{passive:!0}),_dom.default.removeEventListener(document,"pointercancel",this._boundPointerUp,{passive:!0}),_dom.default.removeEventListener(document,"touchend",this._boundPointerUp,{passive:!0}),_dom.default.removeEventListener(document,"contextmenu",this._boundContextMenu,{passive:!0})},DragDrop.prototype._contextMenu=function(e){this.removeAdditionalEventListeners(),this._destroyImage(),this._reset()},DragDrop.prototype._pointerDown=function(e){var target,src,pointerType=e.pointerType;"mouse"===pointerType&&0!==e.button||shouldHandle(e)&&(this._reset(),src=(target=e.target).closest('[draggable="true"]'))&&(this.addAdditionalEventListeners(src),this._dragSource=src,this._dragSourceDraggableX=src.classList.contains("draggable-x"),this._dragSourceDraggableY=src.classList.contains("draggable-y"),this._dragSourceDraggableXY=src.classList.contains("draggable-xy")||!this._dragSourceDraggableX&&!this._dragSourceDraggableY,this._ptDown=getPoint(e),this._lastPointerEvent=e,src=target.classList.contains("dragHandle")?200:400,pointerType||"touchstart"===e.type&&(pointerType="touch"),pointerType&&"touch"!==pointerType&&(src=0),this._pointerDownTime=e.timeStamp,this._delay=src)},DragDrop.prototype._PointerMove=function(e){if("touch"!==e.pointerType||"pointermove"!==e.type){var dragEnabled=this._isDragEnabled,pt=getPoint(e),ptDown=this._ptDown,deltaX=Math.abs(pt.x-ptDown.x),ptDown=Math.abs(pt.y-ptDown.y),dragSource=this._dragSource,deltaX=(!dragEnabled&&dragSource&&this._dragSourceDraggableX&&(ptDown<=5&&5<deltaX||ptDown<=3&&0<deltaX)&&(this._isDragEnabled=dragEnabled=!0,this._dragY=!1),dragEnabled||e.timeStamp-this._pointerDownTime>=this._delay&&this._dragSourceDraggableXY&&(this._dragY=!0,this._dragX=!0,this._isDragEnabled=dragEnabled=!0),deltaX+ptDown);if(!dragEnabled&&10<deltaX)this._reset();else if(dragEnabled){e.preventDefault();ptDown=e.touches;if(!ptDown||ptDown.length){var target=function(pt){pt=document.elementFromPoint(pt.x,pt.y);if(pt){var btn=pt.closest("a,button,div[tabindex]");if(btn)return btn}return pt}(pt);if(dragSource&&!this._img&&5<deltaX){if(dispatchEvent(this,this._lastPointerEvent,"dragstart",dragSource,pt))return this._dragSource=null,this._dragSourceDraggableX=null,this._dragSourceDraggableY=null,void(this._dragSourceDraggableXY=null);this._createImage(e),dispatchEvent(this,e,"dragenter",target,pt)}if(this._img){this._lastPointerEvent=e;dragEnabled=this._lastTarget;if(target===dragEnabled||dragEnabled&&null!=target&&target.contains(dragEnabled)?dragEnabled&&(target=dragEnabled):(dragEnabled&&(dragEnabled.parentNode.style.cursor=null,dragEnabled.style.pointerEvents=null),dispatchEvent(this,this._lastPointerEvent,"dragleave",dragEnabled,pt),dispatchEvent(this,e,"dragenter",target,pt),this._lastTarget=target),this._moveImage(e,pt),null!=target&&target.matches("a,button,div[tabindex]")&&(target.style.pointerEvents="none"),dispatchEvent(this,e,"dragover",target,pt))switch(this._isDropZone=!0,this._dataTransfer.dropEffectEmby){case"copy":target.parentNode.style.cursor="copy";break;case"move":target.parentNode.style.cursor="move";break;case"none":target.parentNode.style.cursor="no-drop";break;case"link":target.parentNode.style.cursor="alias";break;default:target.parentNode.style.cursor="copy"}else this._isDropZone=!1,target&&(target.parentNode.style.cursor="no-drop");dispatchEvent(this,e,"drag",dragSource,pt)}}}}},DragDrop.prototype._PointerUp=function(e){var pt;this.removeAdditionalEventListeners(),this._destroyImage(),shouldHandle(e)&&this._dragSource&&(pt=getPoint(this._lastPointerEvent),e.type.indexOf("cancel")<0&&this._isDropZone&&dispatchEvent(this,this._lastPointerEvent,"drop",this._lastTarget,pt),dispatchEvent(this,this._lastPointerEvent,"dragend",this._dragSource,pt)),this._reset()},DragDrop.prototype._reset=function(){this.removeAdditionalEventListeners(),this._destroyImage(),this._dragSource=null,this._dragSourceDraggableX=null,this._dragSourceDraggableY=null,this._dragSourceDraggableXY=null,this._lastPointerEvent=null;var lastTarget=this._lastTarget;lastTarget&&(lastTarget.parentNode.style.cursor=null,lastTarget.style.pointerEvents=null),this._lastTarget=null,this._ptDown=null,this._isDragEnabled=!1,this._isDropZone=!1,this._dataTransfer=null,this._pointerDownTime=0,this._delay=0,this._dragX=!0,this._dragY=!0},DragDrop.prototype._createImage=function(e){this._img&&this._destroyImage();var src=this._dragSource,src=(this._img=src.cloneNode(!0),!function copyStyle(src,dst){{var cSrc,cDst;src instanceof HTMLCanvasElement&&(cSrc=src,(cDst=dst).width=cSrc.width,cDst.height=cSrc.height,cDst.getContext("2d").drawImage(cSrc,0,0))}var cs=getComputedStyle(src);var i;for(i=0;i<cs.length;i++){var key=cs[i];key.indexOf("transition")<0&&(dst.style[key]=cs[key])}dst.style.pointerEvents="none";for(i=0;i<src.children.length;i++)copyStyle(src.children[i],dst.children[i]);dst.style.transform="none";dst.style.translate="none";dst.style.scale="none"}(src,this._img),src.getBoundingClientRect()),left=(this._img.style.opacity=".9",this._img.style.position="absolute",this._img.style.pointerEvents="none",this._img.style.zIndex="999999",src.left),src=src.top;this._img.style.left=Math.round(left)+"px",this._img.style.top=Math.round(src)+"px",this._img.classList.add("dragClone"),document.body.appendChild(this._img),this._img.offsetWidth,this._img.classList.add("dragging")},DragDrop.prototype._destroyImage=function(){var img=this._img;img&&(this._img=null,(this._isDropZone&&!1!==this._dragY?removeImage:function(instance,img,dragSource,lastPointerEvent){var time=!1===instance._dragY?400:300,opacityTime=instance._dragX&&instance._dragY?time-20:time;img.style.transition="transform "+time+"ms ease-out,opacity "+opacityTime+"ms ease-out",img.classList.remove("dragging"),img.style.transform="none",img.style.opacity="1",setTimeout(function(){removeImage(instance,img,dragSource,lastPointerEvent)},time)})(this,img,this._dragSource,this._lastPointerEvent))},DragDrop.prototype._moveImage=function(e,pt){var _this=this;requestAnimationFrame(function(){var ptDown,deltaX,deltaY,img=_this._img;img&&(img=img.style,ptDown=_this._ptDown,deltaX=pt.x-ptDown.x,deltaY=pt.y-ptDown.y,_this._dragX||(deltaX=0),_this._dragY||(deltaY=0),img.transform="translate("+Math.round(deltaX)+"px, "+Math.round(deltaY)+"px)",_this._dragY)&&!function(e,pt,ptDown){var rect,boundarySize,topY1;"mouse"===e.pointerType&&(e=e.target.closest(".emby-scroller.scrollFrameY"))&&(rect=e.getScrollContainerBoundingClientRect(),boundarySize=Math.round(rect.height/6),topY1=rect.top,pt.y>=topY1&&pt.y<topY1+boundarySize?pt.y<ptDown.y&&e.scrollBy(-20):(topY1=rect.bottom,pt.y>=topY1-boundarySize&&pt.y<topY1&&pt.y>ptDown.y&&e.scrollBy(20)))}(e,pt,ptDown)})},new DragDrop});