/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.main.Main;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.URLUtil;

public class ClasspathLauncher {
    private static String getJavaCommand() {
        String home2 = SafePropertyAccessor.getProperty("java.home", "");
        Object command = home2 + "/bin/java";
        if (!new File((String)command).exists()) {
            command = home2 + "/jre/bin/java";
        }
        if (!new File((String)command).exists()) {
            command = "java";
        }
        return command;
    }

    private static String getJRubyJar() {
        Class<Main> clazz = Main.class;
        URL classResource = clazz.getResource(clazz.getSimpleName() + ".class");
        if (classResource == null) {
            return null;
        }
        String jarPath = classResource.toString().replaceAll("^jar:(file:.*[.]jar)!/.*", "$1");
        try {
            return Paths.get(new URL(jarPath).toURI()).toString();
        }
        catch (MalformedURLException | URISyntaxException | FileSystemNotFoundException e) {
            return null;
        }
    }

    public static String jrubyCommand(ClassLoader classLoader) {
        StringBuilder command = new StringBuilder().append(ClasspathLauncher.getJavaCommand()).append(" -cp ");
        String mainJar = ClasspathLauncher.getJRubyJar();
        if (classLoader instanceof URLClassLoader) {
            ClasspathLauncher.getClassPathEntriesJava8AndBelow((URLClassLoader)classLoader, command, mainJar);
        } else {
            String path2 = SafePropertyAccessor.getProperty("java.class.path");
            if (mainJar != null) {
                command.append(mainJar);
                if (path2 != null) {
                    command.append(File.pathSeparatorChar).append(path2);
                }
            } else {
                command.append(path2);
            }
        }
        return command.append(" org.jruby.main.Main").toString();
    }

    private static void getClassPathEntriesJava8AndBelow(URLClassLoader classLoader, StringBuilder command, String mainJar) {
        ArrayList<String> entries2 = new ArrayList<String>();
        if (mainJar != null) {
            entries2.add(mainJar);
        }
        for (URL url : classLoader.getURLs()) {
            String path2 = URLUtil.getPlatformPath(url);
            if (path2 == null) continue;
            entries2.add(path2);
        }
        command.append(String.join((CharSequence)File.pathSeparator, entries2));
    }

    public static String jrubyCommand(Ruby runtime2) {
        return ClasspathLauncher.jrubyCommand(runtime2.getJRubyClassLoader().getParent());
    }
}

