/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.impl.AccessLogLevel;
import org.directwebremoting.servlet.ExceptionHandler;
import org.directwebremoting.servlet.NotFoundHandler;
import org.directwebremoting.servlet.ResponseHandler;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

public class UrlProcessor
implements Handler,
InitializingBean {
    protected String indexHandlerUrl;
    protected Map<String, Handler> urlMapping = new HashMap<String, Handler>();
    protected Map<Handler, ResponseHandler> responseHandlerMapping = new HashMap<Handler, ResponseHandler>();
    protected Handler notFoundHandler = new NotFoundHandler();
    protected ExceptionHandler exceptionHandler = new ExceptionHandler();
    protected String contextPath = null;
    private boolean debug = false;
    protected String accessLogLevel = null;
    private static final Log log = LogFactory.getLog(UrlProcessor.class);

    @Override
    public void afterContainerSetup(Container container) {
        Collection<String> beanNames = container.getBeanNames();
        for (String name : beanNames) {
            if (!name.startsWith("url:")) continue;
            Object bean = container.getBean(name);
            if (bean instanceof Handler) {
                Handler handler = (Handler)bean;
                this.urlMapping.put(name.substring("url:".length()), handler);
                continue;
            }
            if (bean instanceof String) {
                log.debug((Object)("Probably not an issue: the " + name + " (" + bean + ") Handler is not available. This is only a problem if you wanted to use it."));
                continue;
            }
            log.error((Object)("Discarding non Handler for " + name + " (" + bean.getClass().getName() + " is not an instance of " + Handler.class.getName() + ")"));
        }
        for (Handler handler : this.urlMapping.values()) {
            ResponseHandler responseHandler = this.findConfiguredResponseHandler(handler.getClass(), container);
            if (responseHandler == null) {
                log.warn((Object)("Missing ResponseHandler for " + handler.getClass().getName() + "."));
            }
            this.responseHandlerMapping.put(handler, responseHandler);
        }
        ServletContext servletContext = container.getBean(ServletContext.class);
        this.contextPath = LocalUtil.getProperty(servletContext, "contextPath", String.class);
    }

    private ResponseHandler findConfiguredResponseHandler(Class<?> handlerClass, Container container) {
        ResponseHandler responseHandler;
        if (handlerClass == null || !Handler.class.isAssignableFrom(handlerClass)) {
            return null;
        }
        String key = "response:" + handlerClass.getName();
        Object bean = container.getBean(key);
        if (bean != null) {
            if (bean instanceof ResponseHandler) {
                return (ResponseHandler)bean;
            }
            log.error((Object)("Ignoring non ResponseHandler for " + key + " (" + bean.getClass().getName() + " is not an instance of " + ResponseHandler.class.getName() + ")"));
        }
        if ((responseHandler = this.findConfiguredResponseHandler(handlerClass.getSuperclass(), container)) != null) {
            return responseHandler;
        }
        for (Class<?> intfc : handlerClass.getInterfaces()) {
            responseHandler = this.findConfiguredResponseHandler(intfc, container);
            if (responseHandler == null) continue;
            return responseHandler;
        }
        return null;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String pathInfo = request.getPathInfo();
            String requestContextPath = request.getContextPath();
            if (AccessLogLevel.getValue(this.accessLogLevel, this.debug).hierarchy() == 0) {
                Loggers.ACCESS.info((Object)("Incoming request: " + request.getRequestURI()));
            }
            if (this.contextPath == null) {
                this.contextPath = requestContextPath;
            }
            if (pathInfo == null || pathInfo.length() == 0 || "/".equals(pathInfo)) {
                response.sendRedirect(requestContextPath + request.getServletPath() + this.indexHandlerUrl);
            } else {
                for (Map.Entry<String, Handler> entry : this.urlMapping.entrySet()) {
                    String url = entry.getKey();
                    if (!pathInfo.startsWith(url)) continue;
                    Handler handler = entry.getValue();
                    this.handle(handler, request, response);
                    return;
                }
                this.handle(this.notFoundHandler, request, response);
            }
        }
        catch (SecurityException se) {
            log.error((Object)"Security Exception: ", (Throwable)se);
            this.handle(this.notFoundHandler, request, response);
        }
        catch (Exception ex) {
            this.exceptionHandler.setException(ex);
            this.handle(this.exceptionHandler, request, response);
        }
    }

    private void handle(Handler handler, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResponseHandler responseHandler = this.responseHandlerMapping.get(handler);
        if (responseHandler != null) {
            responseHandler.handle(handler, request, response);
        }
        handler.handle(request, response);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setIndexHandlerUrl(String indexHandlerUrl) {
        this.indexHandlerUrl = indexHandlerUrl;
    }

    public void setAccessLogLevel(String accessLogLevel) {
        this.accessLogLevel = accessLogLevel;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

