/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.settings.Setting;
import org.opensearch.timeseries.settings.DynamicNumericSetting;

public class ADNumericSetting
extends DynamicNumericSetting {
    private static ADNumericSetting INSTANCE;
    public static final String CATEGORY_FIELD_LIMIT = "plugins.anomaly_detection.category_field_limit";
    public static final String JVM_HEAP_USAGE_THRESHOLD = "plugins.anomaly_detection.jvm_heap_usage_threshold";
    private static final Map<String, Setting<?>> settings;

    ADNumericSetting(Map<String, Setting<?>> settings) {
        super(settings);
    }

    public static synchronized ADNumericSetting getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ADNumericSetting(settings);
        }
        return INSTANCE;
    }

    public static int maxCategoricalFields() {
        return (Integer)ADNumericSetting.getInstance().getSettingValue(CATEGORY_FIELD_LIMIT);
    }

    public static int getJVMHeapUsageThreshold() {
        return (Integer)ADNumericSetting.getInstance().getSettingValue(JVM_HEAP_USAGE_THRESHOLD);
    }

    static {
        settings = Collections.unmodifiableMap(new HashMap<String, Setting<?>>(){
            {
                this.put(ADNumericSetting.CATEGORY_FIELD_LIMIT, Setting.intSetting((String)ADNumericSetting.CATEGORY_FIELD_LIMIT, (int)2, (int)0, (int)5, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(ADNumericSetting.JVM_HEAP_USAGE_THRESHOLD, Setting.intSetting((String)ADNumericSetting.JVM_HEAP_USAGE_THRESHOLD, (int)95, (int)0, (int)98, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
            }
        });
    }
}

