/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoBounds;
import org.opensearch.client.opensearch._types.aggregations.CompositeValuesSource;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CompositeGeoTileGridAggregationSource
extends CompositeValuesSource
implements ToCopyableBuilder<Builder, CompositeGeoTileGridAggregationSource> {
    @Nullable
    private final GeoBounds bounds;
    @Nullable
    private final Integer precision;
    public static final JsonpDeserializer<CompositeGeoTileGridAggregationSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeGeoTileGridAggregationSource::setupCompositeGeoTileGridAggregationSourceDeserializer);

    private CompositeGeoTileGridAggregationSource(Builder builder) {
        super(builder);
        this.bounds = builder.bounds;
        this.precision = builder.precision;
    }

    public static CompositeGeoTileGridAggregationSource of(Function<Builder, ObjectBuilder<CompositeGeoTileGridAggregationSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Nullable
    public final Integer precision() {
        return this.precision;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCompositeGeoTileGridAggregationSourceDeserializer(ObjectDeserializer<Builder> op) {
        CompositeGeoTileGridAggregationSource.setupCompositeValuesSourceDeserializer(op);
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
        op.add(Builder::precision, JsonpDeserializer.integerDeserializer(), "precision");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.bounds);
        result = 31 * result + Objects.hashCode(this.precision);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeGeoTileGridAggregationSource other = (CompositeGeoTileGridAggregationSource)o;
        return Objects.equals(this.bounds, other.bounds) && Objects.equals(this.precision, other.precision);
    }

    public static class Builder
    extends CompositeValuesSource.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CompositeGeoTileGridAggregationSource> {
        @Nullable
        private GeoBounds bounds;
        @Nullable
        private Integer precision;

        public Builder() {
        }

        private Builder(CompositeGeoTileGridAggregationSource o) {
            super(o);
            this.bounds = o.bounds;
            this.precision = o.precision;
        }

        private Builder(Builder o) {
            super(o);
            this.bounds = o.bounds;
            this.precision = o.precision;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        @Nonnull
        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        @Nonnull
        public final Builder precision(@Nullable Integer value) {
            this.precision = value;
            return this;
        }

        @Override
        @Nonnull
        public CompositeGeoTileGridAggregationSource build() {
            this._checkSingleUse();
            return new CompositeGeoTileGridAggregationSource(this);
        }
    }
}

