/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DataPathStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DataPathStats> {
    @Nullable
    private final String available;
    @Nullable
    private final Long availableInBytes;
    @Nullable
    private final String cacheReserved;
    @Nullable
    private final Long cacheReservedInBytes;
    @Nullable
    private final String free;
    @Nullable
    private final Long freeInBytes;
    @Nullable
    private final String mount;
    @Nullable
    private final String path;
    @Nullable
    private final String total;
    @Nullable
    private final Long totalInBytes;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<DataPathStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataPathStats::setupDataPathStatsDeserializer);

    private DataPathStats(Builder builder) {
        this.available = builder.available;
        this.availableInBytes = builder.availableInBytes;
        this.cacheReserved = builder.cacheReserved;
        this.cacheReservedInBytes = builder.cacheReservedInBytes;
        this.free = builder.free;
        this.freeInBytes = builder.freeInBytes;
        this.mount = builder.mount;
        this.path = builder.path;
        this.total = builder.total;
        this.totalInBytes = builder.totalInBytes;
        this.type = builder.type;
    }

    public static DataPathStats of(Function<Builder, ObjectBuilder<DataPathStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String available() {
        return this.available;
    }

    @Nullable
    public final Long availableInBytes() {
        return this.availableInBytes;
    }

    @Nullable
    public final String cacheReserved() {
        return this.cacheReserved;
    }

    @Nullable
    public final Long cacheReservedInBytes() {
        return this.cacheReservedInBytes;
    }

    @Nullable
    public final String free() {
        return this.free;
    }

    @Nullable
    public final Long freeInBytes() {
        return this.freeInBytes;
    }

    @Nullable
    public final String mount() {
        return this.mount;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    @Nullable
    public final Long totalInBytes() {
        return this.totalInBytes;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.available != null) {
            generator.writeKey("available");
            generator.write(this.available);
        }
        if (this.availableInBytes != null) {
            generator.writeKey("available_in_bytes");
            generator.write(this.availableInBytes.longValue());
        }
        if (this.cacheReserved != null) {
            generator.writeKey("cache_reserved");
            generator.write(this.cacheReserved);
        }
        if (this.cacheReservedInBytes != null) {
            generator.writeKey("cache_reserved_in_bytes");
            generator.write(this.cacheReservedInBytes.longValue());
        }
        if (this.free != null) {
            generator.writeKey("free");
            generator.write(this.free);
        }
        if (this.freeInBytes != null) {
            generator.writeKey("free_in_bytes");
            generator.write(this.freeInBytes.longValue());
        }
        if (this.mount != null) {
            generator.writeKey("mount");
            generator.write(this.mount);
        }
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        if (this.totalInBytes != null) {
            generator.writeKey("total_in_bytes");
            generator.write(this.totalInBytes.longValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDataPathStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.stringDeserializer(), "available");
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::cacheReserved, JsonpDeserializer.stringDeserializer(), "cache_reserved");
        op.add(Builder::cacheReservedInBytes, JsonpDeserializer.longDeserializer(), "cache_reserved_in_bytes");
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::mount, JsonpDeserializer.stringDeserializer(), "mount");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.available);
        result = 31 * result + Objects.hashCode(this.availableInBytes);
        result = 31 * result + Objects.hashCode(this.cacheReserved);
        result = 31 * result + Objects.hashCode(this.cacheReservedInBytes);
        result = 31 * result + Objects.hashCode(this.free);
        result = 31 * result + Objects.hashCode(this.freeInBytes);
        result = 31 * result + Objects.hashCode(this.mount);
        result = 31 * result + Objects.hashCode(this.path);
        result = 31 * result + Objects.hashCode(this.total);
        result = 31 * result + Objects.hashCode(this.totalInBytes);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPathStats other = (DataPathStats)o;
        return Objects.equals(this.available, other.available) && Objects.equals(this.availableInBytes, other.availableInBytes) && Objects.equals(this.cacheReserved, other.cacheReserved) && Objects.equals(this.cacheReservedInBytes, other.cacheReservedInBytes) && Objects.equals(this.free, other.free) && Objects.equals(this.freeInBytes, other.freeInBytes) && Objects.equals(this.mount, other.mount) && Objects.equals(this.path, other.path) && Objects.equals(this.total, other.total) && Objects.equals(this.totalInBytes, other.totalInBytes) && Objects.equals(this.type, other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DataPathStats> {
        @Nullable
        private String available;
        @Nullable
        private Long availableInBytes;
        @Nullable
        private String cacheReserved;
        @Nullable
        private Long cacheReservedInBytes;
        @Nullable
        private String free;
        @Nullable
        private Long freeInBytes;
        @Nullable
        private String mount;
        @Nullable
        private String path;
        @Nullable
        private String total;
        @Nullable
        private Long totalInBytes;
        @Nullable
        private String type;

        public Builder() {
        }

        private Builder(DataPathStats o) {
            this.available = o.available;
            this.availableInBytes = o.availableInBytes;
            this.cacheReserved = o.cacheReserved;
            this.cacheReservedInBytes = o.cacheReservedInBytes;
            this.free = o.free;
            this.freeInBytes = o.freeInBytes;
            this.mount = o.mount;
            this.path = o.path;
            this.total = o.total;
            this.totalInBytes = o.totalInBytes;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.available = o.available;
            this.availableInBytes = o.availableInBytes;
            this.cacheReserved = o.cacheReserved;
            this.cacheReservedInBytes = o.cacheReservedInBytes;
            this.free = o.free;
            this.freeInBytes = o.freeInBytes;
            this.mount = o.mount;
            this.path = o.path;
            this.total = o.total;
            this.totalInBytes = o.totalInBytes;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder available(@Nullable String value) {
            this.available = value;
            return this;
        }

        @Nonnull
        public final Builder availableInBytes(@Nullable Long value) {
            this.availableInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder cacheReserved(@Nullable String value) {
            this.cacheReserved = value;
            return this;
        }

        @Nonnull
        public final Builder cacheReservedInBytes(@Nullable Long value) {
            this.cacheReservedInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder free(@Nullable String value) {
            this.free = value;
            return this;
        }

        @Nonnull
        public final Builder freeInBytes(@Nullable Long value) {
            this.freeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder mount(@Nullable String value) {
            this.mount = value;
            return this;
        }

        @Nonnull
        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public final Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder totalInBytes(@Nullable Long value) {
            this.totalInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public DataPathStats build() {
            this._checkSingleUse();
            return new DataPathStats(this);
        }
    }
}

