/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncRFAAppender
extends AsyncAppender {
    private String maxFileSize = String.valueOf(0xA00000);
    private int maxBackupIndex = 1;
    private String fileName = null;
    private String conversionPattern = null;
    private boolean blocking = true;
    private int bufferSize = 128;
    private RollingFileAppender rollingFileAppender = null;
    private volatile boolean isRollingFileAppenderAssigned = false;

    public void append(LoggingEvent event) {
        if (this.rollingFileAppender == null) {
            this.appendRFAToAsyncAppender();
        }
        super.append(event);
    }

    private synchronized void appendRFAToAsyncAppender() {
        if (!this.isRollingFileAppenderAssigned) {
            PatternLayout patternLayout = this.conversionPattern != null ? new PatternLayout(this.conversionPattern) : new PatternLayout();
            try {
                this.rollingFileAppender = new RollingFileAppender((Layout)patternLayout, this.fileName, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.rollingFileAppender.setMaxBackupIndex(this.maxBackupIndex);
            this.rollingFileAppender.setMaxFileSize(this.maxFileSize);
            this.addAppender((Appender)this.rollingFileAppender);
            this.isRollingFileAppenderAssigned = true;
            super.setBlocking(this.blocking);
            super.setBufferSize(this.bufferSize);
        }
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    public void setConversionPattern(String conversionPattern) {
        this.conversionPattern = conversionPattern;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

