/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.crash.GraphvizCrash;
import net.sourceforge.plantuml.decoration.symbol.USymbolHexagon;
import net.sourceforge.plantuml.dot.DotData;
import net.sourceforge.plantuml.dot.ExeState;
import net.sourceforge.plantuml.dot.GraphvizRuntimeEnvironment;
import net.sourceforge.plantuml.dot.UnparsableGraphvizException;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorderNone;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.skin.SkinParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.BaseFile;
import net.sourceforge.plantuml.svek.ClusterHeader;
import net.sourceforge.plantuml.svek.ClusterManager;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.EntityImageDegenerated;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekEdge;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekResult;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.text.BackSlash;
import net.sourceforge.plantuml.utils.Log;

public final class GraphvizImageBuilder {
    private final DotData dotData;
    private final DotMode dotMode;
    private final UmlSource source;
    private final Pragma pragma;
    private Map<String, Double> maxX;
    private final SName styleName;
    private final DotStringFactory dotStringFactory;
    private final ClusterManager clusterManager;

    public GraphvizImageBuilder(DotData dotData, UmlSource source, Pragma pragma, SName styleName, DotMode dotMode, DotStringFactory dotStringFactory, ClusterManager clusterManager) {
        this.dotData = dotData;
        this.dotMode = dotMode;
        this.styleName = styleName;
        this.source = source;
        this.pragma = pragma;
        this.dotStringFactory = dotStringFactory;
        this.clusterManager = clusterManager;
    }

    public final StyleSignature getDefaultStyleDefinitionArrow(Stereotype stereotype) {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, this.styleName, SName.arrow);
        if (stereotype != null) {
            result = result.withTOBECHANGED(stereotype);
        }
        return result;
    }

    public final StyleSignature getStyleArrowCardinality(Stereotype stereotype) {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, this.styleName, SName.arrow, SName.cardinality);
        if (stereotype != null) {
            result = result.withTOBECHANGED(stereotype);
        }
        return result;
    }

    private boolean isOpalisable(Entity entity) {
        if (this.dotData.getSkinParam().strictUmlStyle()) {
            return false;
        }
        if (entity.isGroup()) {
            return false;
        }
        if (entity.getLeafType() != LeafType.NOTE) {
            return false;
        }
        Link single = this.onlyOneLink(entity);
        if (single == null) {
            return false;
        }
        return single.getOther(entity).getLeafType() != LeafType.NOTE;
    }

    private HColor getBackcolor() {
        Style style = StyleSignatureBasic.of(SName.root, SName.document).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
        return style.value(PName.BackGroundColor).asColor(this.dotData.getSkinParam().getIHtmlColorSet());
    }

    public IEntityImage buildImage(StringBounder stringBounder, BaseFile basefile, String[] dotStrings, boolean fileFormatOptionIsDebugSvek) {
        String svg;
        Object single;
        Entity group;
        if (this.dotData.isDegeneratedWithFewEntities(0)) {
            return new EntityImageSimpleEmpty(this.dotData.getSkinParam().getBackgroundColor());
        }
        if (this.dotData.isDegeneratedWithFewEntities(1) && this.dotData.getUmlDiagramType() != UmlDiagramType.STATE && (group = ((Entity)(single = this.dotData.getLeafs().iterator().next())).getParentContainer()).isRoot() && !(((Entity)single).getUSymbol() instanceof USymbolHexagon)) {
            IEntityImage tmp = GeneralImageBuilder.createEntityImageBlock((Entity)single, this.dotData.isHideEmptyDescriptionForState(), this.dotData.getPortionShower(), null, null, this.dotData.getLinks());
            return new EntityImageDegenerated(tmp, this.getBackcolor());
        }
        this.dotData.removeIrrelevantSametail();
        this.printGroups(stringBounder, this.dotData.getRootGroup());
        this.printEntities(stringBounder, this.getUnpackagedEntities());
        for (Link link : this.dotData.getLinks()) {
            if (link.isRemoved()) continue;
            try {
                SvekNode other;
                SvekNode node;
                ISkinParam skinParam = this.dotData.getSkinParam();
                FontConfiguration labelFont = this.getDefaultStyleDefinitionArrow(link.getStereotype()).getMergedStyle(link.getStyleBuilder()).getFontConfiguration(skinParam.getIHtmlColorSet());
                FontConfiguration cardinalityFont = this.getStyleArrowCardinality(link.getStereotype()).getMergedStyle(link.getStyleBuilder()).getFontConfiguration(skinParam.getIHtmlColorSet());
                SvekEdge line = new SvekEdge(link, skinParam, stringBounder, labelFont, cardinalityFont, this.dotStringFactory.getBibliotekon(), this.pragma, this.dotStringFactory.getGraphvizVersion());
                this.dotStringFactory.getBibliotekon().addLine(line);
                if (this.isOpalisable(link.getEntity1())) {
                    node = this.dotStringFactory.getBibliotekon().getNode(link.getEntity1());
                    other = this.dotStringFactory.getBibliotekon().getNode(link.getEntity2());
                    if (other == null) continue;
                    ((EntityImageNote)node.getImage()).setOpaleLine(line, node, other);
                    line.setOpale(true);
                    continue;
                }
                if (!this.isOpalisable(link.getEntity2())) continue;
                node = this.dotStringFactory.getBibliotekon().getNode(link.getEntity2());
                other = this.dotStringFactory.getBibliotekon().getNode(link.getEntity1());
                if (other == null) continue;
                ((EntityImageNote)node.getImage()).setOpaleLine(line, node, other);
                line.setOpale(true);
            }
            catch (IllegalStateException e) {
                Logme.error(e);
            }
        }
        if (this.dotStringFactory.illegalDotExe()) {
            return this.error(this.dotStringFactory.getDotExe());
        }
        if (basefile == null && (fileFormatOptionIsDebugSvek || this.isSvekTrace()) && (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE || SecurityUtils.getSecurityProfile() == SecurityProfile.LEGACY || SecurityUtils.getSecurityProfile() == SecurityProfile.SANDBOX)) {
            basefile = new BaseFile(null);
        }
        try {
            svg = this.dotStringFactory.getSvg(stringBounder, this.dotMode, basefile, dotStrings);
        }
        catch (IOException e) {
            return GraphvizCrash.build(this.source.getPlainString(BackSlash.lineSeparator()), GraphvizRuntimeEnvironment.getInstance().graphviz244onWindows(), e);
        }
        if (svg.length() == 0) {
            return GraphvizCrash.build(this.source.getPlainString(BackSlash.lineSeparator()), GraphvizRuntimeEnvironment.getInstance().graphviz244onWindows(), new EmptySvgException());
        }
        String graphvizVersion = this.extractGraphvizVersion(svg);
        try {
            this.dotStringFactory.solve(svg);
            SvekResult result = new SvekResult(this.dotData, this.dotStringFactory);
            this.maxX = this.dotStringFactory.getBibliotekon().getMaxX();
            return result;
        }
        catch (Exception e) {
            Log.error("Exception " + e);
            throw new UnparsableGraphvizException(e, graphvizVersion, svg, this.source.getPlainString(BackSlash.lineSeparator()));
        }
    }

    private boolean isSvekTrace() {
        String value = this.pragma.getValue(PragmaKey.SVEK_TRACE);
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    private String extractGraphvizVersion(String svg) {
        Pattern pGraph = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher mGraph = pGraph.matcher(svg);
        if (mGraph.find()) {
            return StringUtils.trin(mGraph.group(1));
        }
        return null;
    }

    private Link onlyOneLink(Entity ent) {
        Link single = null;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis() || !link.contains(ent)) continue;
            if (single != null) {
                return null;
            }
            single = link;
        }
        return single;
    }

    private IEntityImage error(File dotExe) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Dot Executable: " + dotExe);
        ExeState exeState = ExeState.checkFile(dotExe);
        msg.add(exeState.getTextMessage());
        msg.add("Cannot find Graphviz. You should try");
        msg.add(" ");
        msg.add("@startuml");
        msg.add("testdot");
        msg.add("@enduml");
        msg.add(" ");
        msg.add(" or ");
        msg.add(" ");
        msg.add("java -jar plantuml.jar -testdot");
        msg.add(" ");
        return GraphicStrings.createForError(msg, false);
    }

    private void printEntities(StringBounder stringBounder, Collection<Entity> entities2) {
        for (Entity ent : entities2) {
            if (ent.isRemoved()) continue;
            this.printEntity(stringBounder, ent);
        }
    }

    private void printEntity(StringBounder stringBounder, Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException(ent.toString());
        }
        IEntityImage image = this.printEntityInternal(stringBounder, ent);
        SvekNode node = this.dotStringFactory.getBibliotekon().createNode(ent, image, stringBounder);
        this.clusterManager.addNode(node);
    }

    private IEntityImage printEntityInternal(StringBounder stringBounder, Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.dotData.getSkinParam();
            if (skinParam.sameClassWidth()) {
                double width = this.getMaxWidth(stringBounder);
                ((SkinParam)skinParam).setParamSameClassWidth(width);
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, this.dotData.isHideEmptyDescriptionForState(), this.dotData.getPortionShower(), this.dotStringFactory.getBibliotekon(), this.dotStringFactory.getGraphvizVersion(), this.dotData.getLinks());
        }
        return ent.getSvekImage();
    }

    private double getMaxWidth(StringBounder stringBounder) {
        double result = 0.0;
        for (Entity ent : this.dotData.getLeafs()) {
            EntityImageClass im;
            double w;
            if (!ent.getLeafType().isLikeClass() || !((w = (im = new EntityImageClass(ent, this.dotData.getPortionShower())).calculateDimension(stringBounder).getWidth()) > result)) continue;
            result = w;
        }
        return result;
    }

    private Collection<Entity> getUnpackagedEntities() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity ent : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private void printGroups(StringBounder stringBounder, Entity parent) {
        Collection<Entity> groups = this.dotData.getGroupHierarchy().getChildrenGroups(parent);
        for (Entity g : groups) {
            if (g.isRemoved()) continue;
            if (this.dotData.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                g.muteToType(LeafType.EMPTY_PACKAGE);
                this.printEntity(stringBounder, g);
                continue;
            }
            this.printGroup(stringBounder, g);
        }
    }

    private void printGroup(StringBounder stringBounder, Entity g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        ClusterHeader clusterHeader = new ClusterHeader(g, this.dotData.getPortionShower(), stringBounder);
        this.clusterManager.openCluster(g, clusterHeader);
        this.printEntities(stringBounder, g.leafs());
        this.printGroups(stringBounder, g);
        this.clusterManager.closeCluster();
    }

    public String getWarningOrError(int warningOrError) {
        if (this.maxX == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Double> ent : this.maxX.entrySet()) {
            if (!(ent.getValue() > (double)warningOrError)) continue;
            sb.append(ent.getKey() + " is overpassing the width limit.");
            sb.append("\n");
        }
        return sb.length() == 0 ? "" : sb.toString();
    }

    static class EntityImageSimpleEmpty
    implements IEntityImage {
        private final HColor backColor;

        EntityImageSimpleEmpty(HColor backColor) {
            this.backColor = backColor;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public HColor getBackcolor() {
            return this.backColor;
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            return new XDimension2D(10.0, 10.0);
        }

        @Override
        public MinMax getMinMax(StringBounder stringBounder) {
            return MinMax.fromDim(this.calculateDimension(stringBounder));
        }

        @Override
        public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
            return null;
        }

        @Override
        public void drawU(UGraphic ug) {
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.RECTANGLE;
        }

        @Override
        public Margins getShield(StringBounder stringBounder) {
            return Margins.NONE;
        }

        @Override
        public double getOverscanX(StringBounder stringBounder) {
            return 0.0;
        }

        @Override
        public MagneticBorder getMagneticBorder() {
            return new MagneticBorderNone();
        }
    }
}

