"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCodeActions = getCodeActions;
exports.executeCommand = executeCommand;
const vscode_languageserver_1 = require("vscode-languageserver");
const getQuickfixes_1 = require("./getQuickfixes");
const getRefactorings_1 = require("./getRefactorings");
async function getCodeActions(svelteDoc, range, context) {
    const svelteDiagnostics = context.diagnostics.filter(getQuickfixes_1.isIgnorableSvelteDiagnostic);
    if (svelteDiagnostics.length &&
        (!context.only || context.only.includes(vscode_languageserver_1.CodeActionKind.QuickFix))) {
        return await (0, getQuickfixes_1.getQuickfixActions)(svelteDoc, svelteDiagnostics);
    }
    return [];
}
async function executeCommand(svelteDoc, command, args) {
    return await (0, getRefactorings_1.executeRefactoringCommand)(svelteDoc, command, args);
}
//# sourceMappingURL=index.js.map