/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data.type;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.utils.CommonUtils;

public class PostgreIntervalTypeHandler
extends PostgreTypeHandler {
    public static final PostgreIntervalTypeHandler INSTANCE = new PostgreIntervalTypeHandler();
    private static final int INTERVAL_TYPE_YEAR = 262144;
    private static final int INTERVAL_TYPE_MONTH = 131072;
    private static final int INTERVAL_TYPE_DAY = 524288;
    private static final int INTERVAL_TYPE_HOUR = 0x4000000;
    private static final int INTERVAL_TYPE_MINUTE = 0x8000000;
    private static final int INTERVAL_TYPE_SECOND = 0x10000000;
    private static final int INTERVAL_TYPE_NONE = 0x7FFF0000;
    private static final int INTERVAL_MASK_TYPE = -65536;
    private static final int INTERVAL_MASK_PRECISION = 65535;

    private PostgreIntervalTypeHandler() {
    }

    @Override
    public int getTypeModifiers(@NotNull PostgreDataType type, @NotNull String typeName, @NotNull String[] typmod) throws DBException {
        switch (typmod.length) {
            case 0: {
                return PostgreIntervalTypeHandler.getIntervalModifiers(typeName, 0);
            }
            case 1: {
                return PostgreIntervalTypeHandler.getIntervalModifiers(typeName, CommonUtils.toInt((Object)typmod[0]));
            }
        }
        return super.getTypeModifiers(type, typeName, typmod);
    }

    @Override
    @NotNull
    public String getTypeModifiersString(@NotNull PostgreDataType type, int typmod) {
        StringBuilder sb = new StringBuilder();
        if (typmod > 0) {
            Integer precision;
            if (type.getName().endsWith("interval") && PostgreIntervalTypeHandler.isTypedInterval(typmod)) {
                sb.append(' ').append(PostgreIntervalTypeHandler.getIntervalType(typmod));
            }
            if ((precision = this.getTypePrecision(type, typmod)) != null && precision > 0) {
                sb.append('(').append(precision).append(')');
            }
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public Integer getTypePrecision(@NotNull PostgreDataType type, int typmod) {
        if (PostgreIntervalTypeHandler.isPreciseInterval(typmod)) {
            return (short)(typmod & 0xFFFF);
        }
        return null;
    }

    @Nullable
    public static String getIntervalType(int typmod) {
        if (typmod < 0) {
            return null;
        }
        switch (typmod & 0xFFFF0000) {
            case 262144: {
                return "year";
            }
            case 393216: {
                return "year to month";
            }
            case 131072: {
                return "month";
            }
            case 524288: {
                return "day";
            }
            case 0x4080000: {
                return "day to hour";
            }
            case 0xC080000: {
                return "day to minute";
            }
            case 470286336: {
                return "day to second";
            }
            case 0x4000000: {
                return "hour";
            }
            case 0xC000000: {
                return "hour to minute";
            }
            case 0x1C000000: {
                return "hour to second";
            }
            case 0x8000000: {
                return "minute";
            }
            case 0x18000000: {
                return "minute to second";
            }
            case 0x10000000: {
                return "second";
            }
        }
        throw new IllegalArgumentException("Error obtaining interval type from typmod: " + Integer.toHexString(typmod));
    }

    private static boolean isPreciseInterval(int typmod) {
        return (typmod & 0x10000000) > 0;
    }

    private static boolean isTypedInterval(int typmod) {
        return (typmod & 0x7FFF0000) != 0x7FFF0000;
    }

    private static int getIntervalModifiers(@NotNull String name, int precision) throws DBException {
        if (precision < 0 || precision > 6) {
            throw new DBException("Interval precision " + precision + " must be between 0 and 6");
        }
        int typmod = precision;
        switch (name) {
            case "interval year": {
                typmod |= 0x40000;
                break;
            }
            case "interval year to month": {
                typmod |= 0x60000;
                break;
            }
            case "interval month": {
                typmod |= 0x20000;
                break;
            }
            case "interval day": {
                typmod |= 0x80000;
                break;
            }
            case "interval day to hour": {
                typmod |= 0x4080000;
                break;
            }
            case "interval day to minute": {
                typmod |= 0xC080000;
                break;
            }
            case "interval day to second": {
                typmod |= 0x1C080000;
                break;
            }
            case "interval hour": {
                typmod |= 0x4000000;
                break;
            }
            case "interval hour to minute": {
                typmod |= 0xC000000;
                break;
            }
            case "interval hour to second": {
                typmod |= 0x1C000000;
                break;
            }
            case "interval minute": {
                typmod |= 0x8000000;
                break;
            }
            case "interval minute to second": {
                typmod |= 0x18000000;
                break;
            }
            case "interval second": {
                typmod |= 0x10000000;
                break;
            }
            case "interval": {
                typmod |= 0x7FFF0000;
                break;
            }
            default: {
                throw new DBException("Unsupported interval type: '" + name + "'");
            }
        }
        if (!PostgreIntervalTypeHandler.isPreciseInterval(typmod) && precision != 0) {
            throw new DBException("Interval '" + name + "' may not have precision");
        }
        return typmod;
    }
}

