/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ModuleComponentSelectorSerializer
implements Serializer<ModuleComponentSelector> {
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final CapabilitySelectorSerializer capabilitySelectorSerializer;

    public ModuleComponentSelectorSerializer(AttributeContainerSerializer attributeContainerSerializer, CapabilitySelectorSerializer capabilitySelectorSerializer) {
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.capabilitySelectorSerializer = capabilitySelectorSerializer;
    }

    public ModuleComponentSelector read(Decoder decoder) throws IOException {
        String group = decoder.readString();
        String name = decoder.readString();
        VersionConstraint versionConstraint = this.readVersionConstraint(decoder);
        ImmutableAttributes attributes = this.readAttributes(decoder);
        ImmutableSet<CapabilitySelector> capabilitySelectors = this.readCapabilitySelectors(decoder);
        return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(group, name), versionConstraint, (AttributeContainer)attributes, capabilitySelectors);
    }

    public VersionConstraint readVersionConstraint(Decoder decoder) throws IOException {
        String required = decoder.readString();
        String preferred = decoder.readString();
        String strictly = decoder.readString();
        int cpt = decoder.readSmallInt();
        ArrayList<String> rejects = new ArrayList<String>(cpt);
        for (int i = 0; i < cpt; ++i) {
            rejects.add(decoder.readString());
        }
        String branch = decoder.readNullableString();
        return new DefaultImmutableVersionConstraint(preferred, required, strictly, rejects, branch);
    }

    public void write(Encoder encoder, ModuleComponentSelector value) throws IOException {
        encoder.writeString((CharSequence)value.getGroup());
        encoder.writeString((CharSequence)value.getModule());
        this.writeVersionConstraint(encoder, value.getVersionConstraint());
        this.writeAttributes(encoder, ((AttributeContainerInternal)value.getAttributes()).asImmutable());
        this.writeCapabilitySelectors(encoder, value.getCapabilitySelectors());
    }

    public void write(Encoder encoder, String group, String module, VersionConstraint version, ImmutableAttributes attributes, Set<CapabilitySelector> capabilitySelectors) throws IOException {
        encoder.writeString((CharSequence)group);
        encoder.writeString((CharSequence)module);
        this.writeVersionConstraint(encoder, version);
        this.writeAttributes(encoder, attributes);
        this.writeCapabilitySelectors(encoder, capabilitySelectors);
    }

    public void writeVersionConstraint(Encoder encoder, VersionConstraint cst) throws IOException {
        encoder.writeString((CharSequence)cst.getRequiredVersion());
        encoder.writeString((CharSequence)cst.getPreferredVersion());
        encoder.writeString((CharSequence)cst.getStrictVersion());
        List rejectedVersions = cst.getRejectedVersions();
        encoder.writeSmallInt(rejectedVersions.size());
        for (String rejectedVersion : rejectedVersions) {
            encoder.writeString((CharSequence)rejectedVersion);
        }
        encoder.writeNullableString((CharSequence)cst.getBranch());
    }

    private ImmutableAttributes readAttributes(Decoder decoder) throws IOException {
        return this.attributeContainerSerializer.read(decoder);
    }

    private void writeAttributes(Encoder encoder, ImmutableAttributes attributes) throws IOException {
        this.attributeContainerSerializer.write(encoder, (AttributeContainer)attributes);
    }

    private ImmutableSet<CapabilitySelector> readCapabilitySelectors(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.capabilitySelectorSerializer.read(decoder));
        }
        return builder.build();
    }

    private void writeCapabilitySelectors(Encoder encoder, Set<CapabilitySelector> capabilitySelectors) throws IOException {
        encoder.writeSmallInt(capabilitySelectors.size());
        for (CapabilitySelector capabilitySelector : capabilitySelectors) {
            this.capabilitySelectorSerializer.write(encoder, capabilitySelector);
        }
    }
}

