/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.console;

import java.util.Locale;
import org.gradle.util.internal.VersionNumber;

public interface ConsoleMetaData {
    public static final boolean TASK_BAR_PROGRESS_SUPPORTED = ConsoleMetaData.evaluateTaskBarProgressSupport();

    public boolean isStdOutATerminal();

    public boolean isStdErrATerminal();

    public int getCols();

    public int getRows();

    public boolean isWrapStreams();

    default public boolean supportsUnicode() {
        String lang = System.getenv("LANG");
        String lcAll = System.getenv("LC_ALL");
        if (lang != null && (lang.toUpperCase(Locale.ROOT).contains("UTF-8") || lang.toUpperCase(Locale.ROOT).contains("UTF8")) || lcAll != null && (lcAll.toUpperCase(Locale.ROOT).contains("UTF-8") || lcAll.toUpperCase(Locale.ROOT).contains("UTF8"))) {
            return true;
        }
        String term = System.getenv("TERM");
        if (term != null) {
            String lowerTerm = term.toLowerCase(Locale.ROOT);
            if (lowerTerm.contains("xterm") || lowerTerm.contains("256color") || lowerTerm.contains("screen") || lowerTerm.contains("tmux") || lowerTerm.contains("rxvt") || lowerTerm.contains("konsole") || lowerTerm.contains("gnome") || lowerTerm.contains("alacritty") || lowerTerm.contains("kitty") || lowerTerm.contains("ghostty") || lowerTerm.contains("wezterm") || lowerTerm.contains("contour") || lowerTerm.contains("foot") || lowerTerm.contains("mlterm") || lowerTerm.equals("st") || lowerTerm.startsWith("st-") || lowerTerm.contains("qterminal") || lowerTerm.contains("weston")) {
                return true;
            }
            if (lowerTerm.equals("dumb") || lowerTerm.equals("unknown")) {
                return false;
            }
        }
        if (System.getenv("WT_SESSION") != null || System.getenv("WT_PROFILE_ID") != null) {
            return true;
        }
        return System.getenv("ConEmuPID") != null;
    }

    default public boolean supportsTaskbarProgress() {
        return TASK_BAR_PROGRESS_SUPPORTED;
    }

    public static boolean evaluateTaskBarProgressSupport() {
        String version;
        String termLowerCase;
        if (System.getenv("ConEmuPID") != null) {
            return true;
        }
        String term = System.getenv("TERM");
        if (term != null && ((termLowerCase = term.toLowerCase(Locale.ROOT)).contains("ghostty") || termLowerCase.contains("kitty"))) {
            return true;
        }
        String termProgram = System.getenv("TERM_PROGRAM");
        if ("iTerm.app".equals(termProgram) && (version = System.getenv("TERM_PROGRAM_VERSION")) != null) {
            VersionNumber versionNumber = VersionNumber.parse((String)version);
            return versionNumber.compareTo(VersionNumber.parse((String)"3.6.6")) >= 0;
        }
        return false;
    }
}

