/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.console;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.terminal.Terminals;
import org.fusesource.jansi.internal.Kernel32;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleMetaData;
import org.gradle.internal.os.OperatingSystem;

public class NativePlatformConsoleDetector
implements ConsoleDetector {
    private static final int WINDOWS_UTF8_CODEPAGE_ID = 65001;
    private final Terminals terminals;

    public NativePlatformConsoleDetector(Terminals terminals) {
        this.terminals = terminals;
    }

    @Override
    public ConsoleMetaData getConsole() {
        String term = System.getenv("TERM");
        OperatingSystem operatingSystem = OperatingSystem.current();
        if ("dumb".equals(term) || operatingSystem.isUnix() && term == null) {
            return null;
        }
        boolean isStdoutATerminal = this.terminals.isTerminal(Terminals.Output.Stdout);
        boolean isStderrATerminal = this.terminals.isTerminal(Terminals.Output.Stderr);
        boolean disableUnicodeSupportDetection = NativePlatformConsoleDetector.isWindowsWithNonUnicodeCodePage();
        try {
            if (isStdoutATerminal) {
                return new NativePlatformConsoleMetaData(isStdoutATerminal, isStderrATerminal, this.terminals.getTerminal(Terminals.Output.Stdout), disableUnicodeSupportDetection);
            }
            if (isStderrATerminal) {
                return new NativePlatformConsoleMetaData(isStdoutATerminal, isStderrATerminal, this.terminals.getTerminal(Terminals.Output.Stderr), disableUnicodeSupportDetection);
            }
            return null;
        }
        catch (NativeException ex) {
            return null;
        }
    }

    static boolean isWindowsWithNonUnicodeCodePage() {
        return OperatingSystem.current().isWindows() && Kernel32.GetConsoleOutputCP() != 65001;
    }

    @Override
    public boolean isConsoleInput() {
        return this.terminals.isTerminalInput();
    }
}

