/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.FineGrainedCacheCleanupStrategy;
import org.gradle.cache.FineGrainedPersistentCache;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.CacheCleanupExecutor;
import org.gradle.cache.internal.DefaultCacheCleanupExecutor;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.cache.internal.filelock.DefaultLockOptions;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class DefaultFineGrainedPersistentCache
implements FineGrainedPersistentCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFineGrainedPersistentCache.class);
    private static final LockOptions EXCLUSIVE_LOCKING_WITH_LOCK_FILE_SYSTEM_CHECK = DefaultLockOptions.mode(FileLockManager.LockMode.Exclusive).ensureAcquiredLockRepresentsStateOnFileSystem();
    private final ProducerGuard<String> guard;
    private final File locksDir;
    private final File internalDir;
    private final CacheCleanupExecutor cleanupExecutor;
    private final File baseDir;
    private final String displayName;
    private final AtomicBoolean alreadyCleaned = new AtomicBoolean();
    private final FileLockManager fileLockManager;

    public DefaultFineGrainedPersistentCache(File baseDir, String displayName, FileLockManager fileLockManager, FineGrainedCacheCleanupStrategy cleanupStrategy) {
        this.baseDir = baseDir;
        this.displayName = displayName;
        this.fileLockManager = fileLockManager;
        this.guard = ProducerGuard.adaptive();
        this.internalDir = new File(baseDir, ".internal");
        this.locksDir = new File(baseDir, ".internal/locks");
        File gcFile = new File(this.internalDir, "gc.properties");
        this.cleanupExecutor = new DefaultCacheCleanupExecutor(this, gcFile, cleanupStrategy.getCleanupStrategy());
    }

    @Override
    public FineGrainedPersistentCache open() {
        try {
            this.alreadyCleaned.set(false);
            FileUtils.forceMkdir((File)this.baseDir);
        }
        catch (Throwable e) {
            throw new CacheOpenException(String.format("Could not open %s.", this), e);
        }
        return this;
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Collection<File> getReservedCacheFiles() {
        return ImmutableList.of((Object)this.internalDir);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public <T> T useCache(String key, Supplier<? extends T> action) {
        DefaultFineGrainedPersistentCache.validateKey(key);
        return (T)this.guard.guardByKey(key, () -> {
            try (FileLock lock = this.acquireLock(key);){
                Object t = action.get();
                return t;
            }
        });
    }

    @Override
    public void useCache(String key, Runnable action) {
        this.useCache(key, () -> {
            action.run();
            return null;
        });
    }

    @Override
    public <T> T withFileLock(String key, Supplier<? extends T> action) {
        DefaultFineGrainedPersistentCache.validateKey(key);
        try (FileLock lock = this.acquireLock(key);){
            T t = action.get();
            return t;
        }
    }

    @Override
    public void withFileLock(String key, Runnable action) {
        this.withFileLock(key, () -> {
            action.run();
            return null;
        });
    }

    private FileLock acquireLock(String key) {
        File lockFile = this.getLockFile(key);
        return this.fileLockManager.lock(lockFile, EXCLUSIVE_LOCKING_WITH_LOCK_FILE_SYSTEM_CHECK, this.displayName, "acquireLock");
    }

    private File getLockFile(String key) {
        return new File(this.locksDir, key + ".lock");
    }

    @Override
    public synchronized void close() {
        if (!this.alreadyCleaned.get()) {
            this.cleanup();
        }
    }

    @Override
    public synchronized void cleanup() {
        try {
            this.alreadyCleaned.set(true);
            this.cleanupExecutor.cleanup();
        }
        catch (Exception e) {
            LOGGER.debug("Cache {} could not run cleanup action", (Object)this.displayName);
        }
    }

    private static void validateKey(String key) {
        Preconditions.checkArgument((!key.contains("/") && !key.contains("\\") ? 1 : 0) != 0, (String)"Cache key path must not contain file separator: '%s'", (Object)key);
        Preconditions.checkArgument((!key.startsWith(".") ? 1 : 0) != 0, (String)"Cache key must not start with '.' character: '%s'", (Object)key);
    }

    public String toString() {
        return this.getDisplayName();
    }
}

