/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.stream.Collectors;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.internal.scripts.ScriptResolutionResult;

public class ScriptResolutionResultReporter {
    private final ProblemReporter problemReporter;

    public ScriptResolutionResultReporter(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public void reportResolutionProblemsOf(ScriptResolutionResult result) {
        if (result.getSelectedCandidate() == null || result.getIgnoredCandidates().isEmpty()) {
            return;
        }
        String ignoredCandidateList = result.getIgnoredCandidates().stream().map(File::getName).map(name -> "'" + name + "'").collect(Collectors.joining(", "));
        this.problemReporter.report(ProblemId.create((String)"multiple-scripts", (String)"Multiple scripts", (ProblemGroup)GradleCoreProblemGroup.scripts()), spec -> spec.contextualLabel(String.format("Multiple %s script files were found in directory '%s'", result.getBasename(), result.getDirectory())).details(String.format("Multiple %s script files were found in directory '%s'. Selected '%s', and ignoring %s.", result.getBasename(), result.getDirectory(), result.getSelectedCandidate().getName(), ignoredCandidateList)).solution(String.format("Delete the files %s in directory '%s'", ignoredCandidateList, result.getDirectory())));
    }
}

