/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.internal.metadata.deserialization;

import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.internal.metadata.ProtoBuf;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.internal.metadata.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ.\u0010\u0014\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0016\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/gradle/kotlin/dsl/internal/relocated/kotlin/metadata/internal/metadata/deserialization/NameResolverImpl;", "Lorg/gradle/kotlin/dsl/internal/relocated/kotlin/metadata/internal/metadata/deserialization/NameResolver;", "strings", "Lorg/gradle/kotlin/dsl/internal/relocated/kotlin/metadata/internal/metadata/ProtoBuf$StringTable;", "qualifiedNames", "Lorg/gradle/kotlin/dsl/internal/relocated/kotlin/metadata/internal/metadata/ProtoBuf$QualifiedNameTable;", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$StringTable;Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable;)V", "getStrings", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$StringTable;", "getQualifiedNames", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable;", "getString", "", "index", "", "getQualifiedClassName", "isLocalClassName", "", "getPackageFqName", "traverseIds", "Lkotlin/Triple;", "", "startingIndex", "metadata"})
public final class NameResolverImpl
implements NameResolver {
    @NotNull
    private final ProtoBuf.StringTable strings;
    @NotNull
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolverImpl(@NotNull ProtoBuf.StringTable strings, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)qualifiedNames, (String)"qualifiedNames");
        this.strings = strings;
        this.qualifiedNames = qualifiedNames;
    }

    @Override
    @NotNull
    public String getString(int index) {
        String string = this.strings.getString(index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedClassName(int index) {
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(index);
        List packageFqNameSegments = (List)triple.component1();
        List relativeClassNameSegments = (List)triple.component2();
        String className = CollectionsKt.joinToString$default((Iterable)relativeClassNameSegments, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return packageFqNameSegments.isEmpty() ? className : CollectionsKt.joinToString$default((Iterable)packageFqNameSegments, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) + '/' + className;
    }

    @Override
    public boolean isLocalClassName(int index) {
        return (Boolean)this.traverseIds(index).getThird();
    }

    @NotNull
    public final String getPackageFqName(int index) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)this.traverseIds(index).getFirst()), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int startingIndex) {
        int index = startingIndex;
        LinkedList<String> packageNameSegments = new LinkedList<String>();
        LinkedList<String> relativeClassNameSegments = new LinkedList<String>();
        boolean local = false;
        while (index != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index);
            String shortName = this.strings.getString(proto.getShortName());
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind2 = proto.getKind();
            Intrinsics.checkNotNull((Object)kind2);
            switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                case 1: {
                    relativeClassNameSegments.addFirst(shortName);
                    break;
                }
                case 2: {
                    packageNameSegments.addFirst(shortName);
                    break;
                }
                case 3: {
                    relativeClassNameSegments.addFirst(shortName);
                    local = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            index = proto.getParentQualifiedName();
        }
        return new Triple(packageNameSegments, relativeClassNameSegments, (Object)local);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.values().length];
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

