/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.DefaultNestedTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultParameterizedTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestFileAttachmentDataEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestKeyValueDataEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.failure.DefaultThrowableToTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertjMultipleAssertionsErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.JUnitComparisonTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestAssertionFailedMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestMultipleFailuresErrorMapper;
import org.gradle.api.internal.tasks.testing.source.DefaultClassSource;
import org.gradle.api.internal.tasks.testing.source.DefaultClasspathResourceSource;
import org.gradle.api.internal.tasks.testing.source.DefaultDirectorySource;
import org.gradle.api.internal.tasks.testing.source.DefaultFilePosition;
import org.gradle.api.internal.tasks.testing.source.DefaultFileSource;
import org.gradle.api.internal.tasks.testing.source.DefaultMethodSource;
import org.gradle.api.internal.tasks.testing.source.DefaultNoSource;
import org.gradle.api.internal.tasks.testing.source.DefaultOtherSource;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.source.ClassSource;
import org.gradle.api.tasks.testing.source.FilePosition;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.id.CompositeIdGenerator;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class JUnitPlatformTestExecutionListener
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitPlatformTestExecutionListener.class);
    private static final List<TestFailureMapper> MAPPERS = Arrays.asList(new OpenTestAssertionFailedMapper(), new OpenTestMultipleFailuresErrorMapper(), new JUnitComparisonTestFailureMapper(), new AssertjMultipleAssertionsErrorMapper(), new AssertErrorMapper());
    private static final DefaultThrowableToTestFailureMapper FAILURE_MAPPER = new DefaultThrowableToTestFailureMapper(MAPPERS);
    private static final boolean HAS_GET_UNIQUE_ID_OBJECT_METHOD = Arrays.stream(TestIdentifier.class.getMethods()).anyMatch(method -> method.getName().equals("getUniqueIdObject"));
    private final ConcurrentMap<String, TestDescriptorInternal> descriptorsByUniqueId = new ConcurrentHashMap<String, TestDescriptorInternal>();
    private final Set<Throwable> fatalExceptions = ConcurrentHashMap.newKeySet();
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final IdGenerator<?> idGenerator;
    private final Collection<Path> testDefinitionDirs;
    private @Nullable TestPlan currentTestPlan;

    private static UniqueId getUniqueIdObject(TestIdentifier testIdentifier) {
        return HAS_GET_UNIQUE_ID_OBJECT_METHOD ? testIdentifier.getUniqueIdObject() : UniqueId.parse((String)testIdentifier.getUniqueId());
    }

    private static UniqueId.Segment getLastUniqueIdSegment(TestIdentifier testIdentifier) {
        UniqueId uniqueIdObject = JUnitPlatformTestExecutionListener.getUniqueIdObject(testIdentifier);
        List segments = uniqueIdObject.getSegments();
        return (UniqueId.Segment)segments.get(segments.size() - 1);
    }

    private static boolean isEngineNode(TestIdentifier testIdentifier) {
        String lastSegmentType = JUnitPlatformTestExecutionListener.getLastUniqueIdSegment(testIdentifier).getType();
        return "engine".equals(lastSegmentType);
    }

    public JUnitPlatformTestExecutionListener(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator, Collection<Path> testDefinitionDirs) {
        this.resultProcessor = resultProcessor;
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.testDefinitionDirs = testDefinitionDirs;
    }

    public void throwAnyFatalExceptions() {
        if (this.fatalExceptions.isEmpty()) {
            return;
        }
        if (this.fatalExceptions.size() == 1) {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.fatalExceptions.iterator().next());
        }
        throw new DefaultMultiCauseException("Multiple fatal exceptions were encountered during test execution", this.fatalExceptions);
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        if (this.wasStarted(testIdentifier)) {
            this.resultProcessor.published(this.getId(testIdentifier), (TestMetadataEvent)new DefaultTestKeyValueDataEvent(JUnitPlatformTestExecutionListener.convertToInstant(entry.getTimestamp()), entry.getKeyValuePairs()));
        } else {
            Object closestStartedAncestor = this.getIdOfClosestStartedAncestor(testIdentifier);
            if (closestStartedAncestor != null) {
                this.resultProcessor.published(closestStartedAncestor, (TestMetadataEvent)new DefaultTestKeyValueDataEvent(JUnitPlatformTestExecutionListener.convertToInstant(entry.getTimestamp()), entry.getKeyValuePairs()));
            }
            LOGGER.debug("report entry published for unknown test identifier {}", (Object)testIdentifier);
        }
    }

    private static Instant convertToInstant(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry entry) {
        String mediaType = entry.getMediaType().orElse(null);
        if (this.wasStarted(testIdentifier)) {
            this.resultProcessor.published(this.getId(testIdentifier), (TestMetadataEvent)new DefaultTestFileAttachmentDataEvent(JUnitPlatformTestExecutionListener.convertToInstant(entry.getTimestamp()), entry.getPath().toAbsolutePath(), mediaType));
        } else {
            Object closestStartedAncestor = this.getIdOfClosestStartedAncestor(testIdentifier);
            if (closestStartedAncestor != null) {
                this.resultProcessor.published(closestStartedAncestor, (TestMetadataEvent)new DefaultTestFileAttachmentDataEvent(JUnitPlatformTestExecutionListener.convertToInstant(entry.getTimestamp()), entry.getPath().toAbsolutePath(), mediaType));
            }
        }
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.currentTestPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.currentTestPlan = null;
        this.descriptorsByUniqueId.clear();
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionSkipped(testIdentifier);
    }

    private void executionSkipped(TestIdentifier testIdentifier) {
        this.executionStarted(testIdentifier);
        this.reportSkipped(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.getParentId().isPresent() && !JUnitPlatformTestExecutionListener.isEngineNode(testIdentifier)) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            testExecutionResult.getThrowable().ifPresent(throwable -> this.resultProcessor.failure(this.getId(testIdentifier), DefaultTestFailure.fromTestAssumptionFailure((Throwable)throwable)));
            this.reportSkipped(testIdentifier);
            return;
        }
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
            Throwable failure = testExecutionResult.getThrowable().orElseGet(() -> new AssertionError((Object)"test failed but did not report an exception"));
            if (testIdentifier.isTest()) {
                this.reportTestFailure(testIdentifier, failure);
            } else {
                TestDescriptorInternal syntheticTestDescriptor = this.createSyntheticTestDescriptorForContainer(testIdentifier);
                this.resultProcessor.started(syntheticTestDescriptor, this.startEvent(this.getId(testIdentifier)));
                this.resultProcessor.failure(syntheticTestDescriptor.getId(), TestFailure.fromTestFrameworkFailure((Throwable)failure));
                this.resultProcessor.completed(syntheticTestDescriptor.getId(), this.completeEvent());
            }
        }
        if (this.wasStarted(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private void reportTestFailure(TestIdentifier testIdentifier, Throwable failure) {
        TestFailure testFailure = FAILURE_MAPPER.createFailure(failure);
        this.resultProcessor.failure(this.getId(testIdentifier), testFailure);
    }

    private void reportStartedUnlessAlreadyStarted(TestIdentifier testIdentifier) {
        boolean wasNotAlreadyStarted = this.createDescriptorIfAbsent(testIdentifier);
        if (wasNotAlreadyStarted) {
            TestDescriptorInternal descriptor = (TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId());
            this.resultProcessor.started(descriptor, this.startEvent(testIdentifier));
        }
    }

    private void reportSkipped(TestIdentifier testIdentifier) {
        Objects.requireNonNull(this.currentTestPlan);
        this.currentTestPlan.getChildren(testIdentifier).stream().filter(child -> !this.wasStarted((TestIdentifier)child)).forEach(this::executionSkipped);
        if (testIdentifier.isTest()) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent(TestResult.ResultType.SKIPPED));
        } else if (JUnitPlatformTestExecutionListener.hasClassSource(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private TestStartEvent startEvent(TestIdentifier testIdentifier) {
        TestDescriptorInternal closestStartedAncestor = this.getClosestStartedAncestor(testIdentifier).orElse(null);
        if (closestStartedAncestor == null) {
            return this.startEvent((Object)null);
        }
        if (!closestStartedAncestor.isComposite()) {
            List allEngines = JUnitPlatformTestExecutionListener.getUniqueIdObject(testIdentifier).getSegments().stream().filter(s -> s.getType().equals("engine")).map(UniqueId.Segment::getValue).collect(Collectors.toList());
            String closestEngine = allEngines.isEmpty() ? "<unknown>" : (String)allEngines.get(allEngines.size() - 1);
            this.fatalExceptions.add(new IllegalStateException("Closest started ancestor '" + closestStartedAncestor + "' is not a container. This likely means the JUnit Platform TestEngine '" + closestEngine + "' tried to start a test under a non-container parent."));
            return this.startEvent((Object)null);
        }
        return this.startEvent(closestStartedAncestor.getId());
    }

    private @Nullable Object getIdOfClosestStartedAncestor(TestIdentifier testIdentifier) {
        return this.getClosestStartedAncestor(testIdentifier).map(TestDescriptorInternal::getId).orElse(null);
    }

    private Optional<TestDescriptorInternal> getClosestStartedAncestor(TestIdentifier testIdentifier) {
        return this.getAncestors(testIdentifier).stream().map(TestIdentifier::getUniqueId).filter(this.descriptorsByUniqueId::containsKey).findFirst().map(this.descriptorsByUniqueId::get);
    }

    private TestStartEvent startEvent(@Nullable Object parentId) {
        return new TestStartEvent(this.clock.getCurrentTime(), parentId);
    }

    private TestCompleteEvent completeEvent() {
        return this.completeEvent(null);
    }

    private TestCompleteEvent completeEvent(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TestResult.ResultType resultType) {
        return new TestCompleteEvent(this.clock.getCurrentTime(), resultType);
    }

    private boolean wasStarted(TestIdentifier testIdentifier) {
        return this.descriptorsByUniqueId.containsKey(testIdentifier.getUniqueId());
    }

    private boolean createDescriptorIfAbsent(TestIdentifier node) {
        MutableBoolean wasCreated = new MutableBoolean(false);
        this.descriptorsByUniqueId.computeIfAbsent(node.getUniqueId(), uniqueId -> {
            wasCreated.set(true);
            if (node.getType().isContainer()) {
                boolean isTestClassId = this.isTestClassIdentifier(node);
                if (!isTestClassId) {
                    Object candidateId;
                    String displayName = node.getDisplayName();
                    Optional<TestDescriptorInternal> parentId = node.getParentId().map(this.descriptorsByUniqueId::get);
                    if (parentId.isPresent() && (candidateId = parentId.get().getId()) instanceof CompositeIdGenerator.CompositeId) {
                        return this.createNestedTestSuite(node, displayName, (CompositeIdGenerator.CompositeId)candidateId);
                    }
                }
                return this.createTestContainerDescriptor(node);
            }
            if (node.getType().isTest()) {
                return this.createTestDescriptor(node, node.getLegacyReportingName(), node.getDisplayName());
            }
            throw new IllegalStateException("Unknown TestIdentifier type: " + node.getType());
        });
        return wasCreated.get();
    }

    private DefaultTestSuiteDescriptor createNestedTestSuite(TestIdentifier node, String displayName, CompositeIdGenerator.CompositeId candidateId) {
        Optional<MethodSource> methodSource = JUnitPlatformTestExecutionListener.getMethodSource(node);
        if (methodSource.isPresent()) {
            TestDescriptorInternal parentDescriptor = this.findTestParentDescriptor(node);
            String className = this.determineClassName(node, parentDescriptor);
            return new DefaultParameterizedTestDescriptor(this.idGenerator.generateId(), node.getLegacyReportingName(), className, displayName, candidateId);
        }
        return new DefaultNestedTestSuiteDescriptor(this.idGenerator.generateId(), node.getLegacyReportingName(), displayName, candidateId);
    }

    private DefaultTestClassDescriptor createTestContainerDescriptor(TestIdentifier node) {
        String name = this.extractClassOrResourceName(node);
        String classDisplayName = node.getDisplayName();
        return new DefaultTestClassDescriptor(this.idGenerator.generateId(), name, classDisplayName, JUnitPlatformTestExecutionListener.sourceOf(node));
    }

    private static org.gradle.api.tasks.testing.source.TestSource sourceOf(TestIdentifier node) {
        return node.getSource().map(s -> JUnitPlatformTestExecutionListener.sourceOf(s)).orElse((org.gradle.api.tasks.testing.source.TestSource)DefaultNoSource.getInstance());
    }

    public static org.gradle.api.tasks.testing.source.TestSource sourceOf(TestSource source) {
        if (source instanceof FileSource) {
            FileSource fileSource = (FileSource)source;
            FilePosition position = fileSource.getPosition().map(p -> new DefaultFilePosition(p.getLine(), (Integer)p.getColumn().orElse(null))).orElse(null);
            return new DefaultFileSource(fileSource.getFile(), position);
        }
        if (source instanceof DirectorySource) {
            return new DefaultDirectorySource(((DirectorySource)source).getFile());
        }
        if (source instanceof org.junit.platform.engine.support.descriptor.ClassSource) {
            org.junit.platform.engine.support.descriptor.ClassSource classSource = (org.junit.platform.engine.support.descriptor.ClassSource)source;
            return new DefaultClassSource(classSource.getClassName());
        }
        if (source instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)source;
            return new DefaultMethodSource(methodSource.getClassName(), methodSource.getMethodName());
        }
        if (source instanceof ClasspathResourceSource) {
            ClasspathResourceSource classpathResourceSource = (ClasspathResourceSource)source;
            FilePosition position = classpathResourceSource.getPosition().map(p -> new DefaultFilePosition(p.getLine(), (Integer)p.getColumn().orElse(null))).orElse(null);
            return new DefaultClasspathResourceSource(classpathResourceSource.getClasspathResourceName(), position);
        }
        return DefaultOtherSource.getInstance();
    }

    private TestDescriptorInternal createSyntheticTestDescriptorForContainer(TestIdentifier node) {
        assert (this.currentTestPlan != null);
        boolean testsStarted = this.currentTestPlan.getDescendants(node).stream().anyMatch(this::wasStarted);
        String name = testsStarted ? "executionError" : "initializationError";
        return this.createTestDescriptor(node, name, name);
    }

    private TestDescriptorInternal createTestDescriptor(TestIdentifier test, String name, String displayName) {
        TestDescriptorInternal parentDescriptor = this.findTestParentDescriptor(test);
        String className = this.determineClassName(test, parentDescriptor);
        String classDisplayName = this.determineClassDisplayName(test, parentDescriptor);
        return new DefaultTestDescriptor(this.idGenerator.generateId(), className, name, classDisplayName, displayName, JUnitPlatformTestExecutionListener.sourceOf(test));
    }

    private String determineClassName(TestIdentifier node, @Nullable TestDescriptorInternal parentDescriptor) {
        return this.determineClassRelatedName(node, parentDescriptor, TestDescriptor::getName);
    }

    private String determineClassDisplayName(TestIdentifier node, @Nullable TestDescriptorInternal parentDescriptor) {
        return this.determineClassRelatedName(node, parentDescriptor, TestDescriptorInternal::getClassDisplayName);
    }

    private String determineClassRelatedName(TestIdentifier node, @Nullable TestDescriptorInternal parentDescriptor, Function<TestDescriptorInternal, @Nullable String> nameGetter) {
        TestSource source = node.getSource().orElse(null);
        if (source instanceof org.junit.platform.engine.support.descriptor.ClassSource || source instanceof MethodSource) {
            if (parentDescriptor == null) {
                return "UnknownClass";
            }
            String result = nameGetter.apply(parentDescriptor);
            return result != null ? result : "Unknown";
        }
        if (source == null && parentDescriptor != null && parentDescriptor.getSource() instanceof ClassSource) {
            String result = nameGetter.apply(parentDescriptor);
            return result != null ? result : "Unknown";
        }
        return "";
    }

    private Object getId(TestIdentifier testIdentifier) {
        return ((TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId())).getId();
    }

    private Set<TestIdentifier> getAncestors(TestIdentifier testIdentifier) {
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>();
        Optional<TestIdentifier> parent = this.getParent(testIdentifier);
        while (parent.isPresent()) {
            result.add(parent.get());
            parent = this.getParent(parent.get());
        }
        return result;
    }

    private @Nullable TestIdentifier findTestClassIdentifier(TestIdentifier testIdentifier) {
        return this.findInAncestors(testIdentifier, identifier -> this.isTestClassIdentifier((TestIdentifier)identifier) ? identifier : null);
    }

    private @Nullable TestDescriptorInternal findTestParentDescriptor(TestIdentifier testIdentifier) {
        TestIdentifier classIdentifier = this.findTestClassIdentifier(testIdentifier);
        if (classIdentifier != null) {
            return (TestDescriptorInternal)this.descriptorsByUniqueId.get(classIdentifier.getUniqueId());
        }
        return this.findInAncestors(testIdentifier, identifier -> (TestDescriptorInternal)this.descriptorsByUniqueId.get(identifier.getUniqueId()));
    }

    private <T> @Nullable T findInAncestors(TestIdentifier testIdentifier, Function<TestIdentifier, @Nullable T> mapper) {
        TestIdentifier current = testIdentifier;
        while (current != null && !JUnitPlatformTestExecutionListener.isEngineNode(current)) {
            T result = mapper.apply(current);
            if (result != null) {
                return result;
            }
            current = this.getParent(current).orElse(null);
        }
        return null;
    }

    private Optional<TestIdentifier> getParent(TestIdentifier testIdentifier) {
        Objects.requireNonNull(this.currentTestPlan);
        try {
            return testIdentifier.getParentIdObject().map(arg_0 -> ((TestPlan)this.currentTestPlan).getTestIdentifier(arg_0));
        }
        catch (BootstrapMethodError | NoSuchMethodError ignore) {
            return testIdentifier.getParentId().map(arg_0 -> ((TestPlan)this.currentTestPlan).getTestIdentifier(arg_0));
        }
    }

    private boolean isTestClassIdentifier(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.hasClassSource(testIdentifier) && this.hasDifferentSourceThanAncestor(testIdentifier);
    }

    private String extractClassOrResourceName(TestIdentifier node) {
        Optional<String> fileSourceName;
        Optional<org.junit.platform.engine.support.descriptor.ClassSource> classSource;
        TestIdentifier testClassIdentifier = this.findTestClassIdentifier(node);
        if (testClassIdentifier != null && (classSource = JUnitPlatformTestExecutionListener.getClassSource(testClassIdentifier)).isPresent()) {
            return classSource.get().getClassName();
        }
        if (JUnitPlatformTestExecutionListener.hasFileSource(node) && (fileSourceName = this.computeNameForFileBasedTest(node)).isPresent()) {
            return fileSourceName.get();
        }
        UniqueId.Segment lastSegment = JUnitPlatformTestExecutionListener.getLastUniqueIdSegment(node);
        return (lastSegment.getType() + "_" + lastSegment.getValue()).replace(':', '_');
    }

    private Optional<String> computeNameForFileBasedTest(TestIdentifier node) {
        Object source = node.getSource().orElse(null);
        if (!(source instanceof FileSource)) {
            throw new IllegalArgumentException("Node source must be a FileSource, was: " + source);
        }
        try {
            Path path = ((FileSource)source).getFile().toPath().toRealPath(new LinkOption[0]);
            for (Path testDefinitionDir : this.testDefinitionDirs) {
                if (!path.startsWith(testDefinitionDir)) continue;
                String relativePath = TextUtil.normaliseFileSeparators((String)testDefinitionDir.relativize(path).toString());
                return Optional.of(relativePath);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not compute relative path to source file for test identifier {}", (Object)node, (Object)e);
        }
        return Optional.empty();
    }

    private static boolean hasClassSource(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.getClassSource(testIdentifier).isPresent();
    }

    private static Optional<org.junit.platform.engine.support.descriptor.ClassSource> getClassSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(source -> source instanceof org.junit.platform.engine.support.descriptor.ClassSource).map(source -> (org.junit.platform.engine.support.descriptor.ClassSource)source);
    }

    private static Optional<MethodSource> getMethodSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(source -> source instanceof MethodSource).map(source -> (MethodSource)source);
    }

    private static boolean hasFileSource(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.getFileSource(testIdentifier).isPresent();
    }

    private static Optional<FileSource> getFileSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(source -> source instanceof FileSource).map(source -> (FileSource)source);
    }

    private boolean hasDifferentSourceThanAncestor(TestIdentifier testIdentifier) {
        Objects.requireNonNull(this.currentTestPlan);
        Optional parent = this.currentTestPlan.getParent(testIdentifier);
        while (parent.isPresent()) {
            if (Objects.equals(((TestIdentifier)parent.get()).getSource(), testIdentifier.getSource())) {
                return false;
            }
            parent = this.currentTestPlan.getParent((TestIdentifier)parent.get());
        }
        return true;
    }
}

