/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform.filters;

import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.FileSystemSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

public final class FilePathFilter
implements PostDiscoveryFilter {
    private final TestSelectionMatcher matcher;

    public FilePathFilter(TestSelectionMatcher matcher) {
        this.matcher = matcher;
    }

    public FilterResult apply(TestDescriptor descriptor) {
        return FilterResult.includedIf((boolean)this.shouldRun(descriptor), () -> "File match", () -> "File mismatch");
    }

    private boolean shouldRun(TestDescriptor descriptor) {
        TestSource testSource = (TestSource)descriptor.getSource().orElseThrow(() -> new IllegalArgumentException("No test source found for " + descriptor));
        if (testSource instanceof FileSource || testSource instanceof DirectorySource) {
            return this.matcher.matchesFile(((FileSystemSource)testSource).getFile());
        }
        return false;
    }
}

