/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.internal.tasks.testing.filter.ClassTestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.filter.FileTestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;
import org.jspecify.annotations.Nullable;

public class TestSelectionMatcher {
    private final ClassTestSelectionMatcher classTestSelectionMatcher;
    private final FileTestSelectionMatcher fileTestSelectionMatcher;

    public TestSelectionMatcher(TestFilterSpec filter) {
        this(filter, Collections.emptyList());
    }

    public TestSelectionMatcher(TestFilterSpec filter, Collection<Path> roots) {
        this.classTestSelectionMatcher = new ClassTestSelectionMatcher(filter.getIncludedTests(), filter.getExcludedTests(), filter.getIncludedTestsCommandLine());
        this.fileTestSelectionMatcher = new FileTestSelectionMatcher(this.classTestSelectionMatcher, roots);
    }

    public boolean matchesFile(File file) {
        return this.fileTestSelectionMatcher.matchesFile(file);
    }

    public boolean matchesTest(String className, @Nullable String methodName) {
        return this.classTestSelectionMatcher.matchesTest(className, methodName);
    }

    public boolean mayIncludeClass(String fullQualifiedClassName) {
        return this.classTestSelectionMatcher.mayIncludeClass(fullQualifiedClassName);
    }
}

