/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.internal.buildoption.BooleanOptionUtil;
import org.gradle.internal.buildoption.FeatureFlag;
import org.gradle.internal.buildoption.FeatureFlagListener;
import org.gradle.internal.buildoption.FeatureFlags;

public class DefaultFeatureFlags
implements FeatureFlags {
    private final Set<FeatureFlag> enabled = new CopyOnWriteArraySet<FeatureFlag>();
    private final FeatureFlagListener broadcaster;
    private final Map<String, String> startParameterSystemProperties;

    public DefaultFeatureFlags(FeatureFlagListener listener, Map<String, String> startParameterSystemProperties) {
        this.startParameterSystemProperties = startParameterSystemProperties;
        this.broadcaster = listener;
    }

    @Override
    public boolean isEnabled(FeatureFlag flag) {
        String systemPropertyValue;
        this.broadcaster.flagRead(flag);
        if (flag.getSystemPropertyName() != null && (systemPropertyValue = this.startParameterSystemProperties.get(flag.getSystemPropertyName())) != null) {
            return BooleanOptionUtil.isTrue(systemPropertyValue);
        }
        return this.enabled.contains(flag);
    }

    @Override
    public void enable(FeatureFlag flag) {
        this.enabled.add(flag);
    }

    @Override
    public boolean isEnabledWithApi(FeatureFlag flag) {
        return this.enabled.contains(flag);
    }
}

