<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown_small" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="BASEGroup">
                                <queryInherit>/BASE_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BASEGroupExpanded">
                                        <queryRef>/FP_Arith_small</queryRef>
                                        <queryRef>/OTHER_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <queryRef>/MicroSequencer_small</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="FELatencyGroup">
                                <queryInherit>/FELatency_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FELatencyGroupExpanded">
                                        <queryRef>/ICacheMisses_small</queryRef>
                                        <queryRef>/ITLBOverhead_small</queryRef>
                                        <queryRef>/BACLEARS_small</queryRef>
                                        <queryRef>/BranchResteers_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FEBandwidthGroup">
                                <queryInherit>/FEBandwidth_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FEBandwidthGroupExpanded">
                                        <queryRef>/FEBandwidthCisc_small</queryRef>
                                        <queryRef>/FEBandwidthDecode_small</queryRef>
                                        <queryRef>/PreDecodeWrong_small</queryRef>
                                        <queryRef>/FEOther_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <queryRef>/BranchMispredict_small</queryRef>
                            <derivedQuery id="MachineClearsGroup">
                                <queryInherit>/MachineClears_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MachineClearsGroupExpanded">
                                        <derivedQuery id="MachineClearsNukeGroup">
                                            <queryInherit>/MachineClearsNuke_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MachineClearsNukeGroupExpanded">
                                                    <queryRef>/SMCMachineClear_small</queryRef>
                                                    <queryRef>/MOMachineClear_small</queryRef>
                                                    <queryRef>/FPAssistMachineClear_small</queryRef>
                                                    <queryRef>/Disambiguation_small</queryRef>
                                                    <queryRef>/PageFaultMachineClear_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/FastMachineClear_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <queryRef>/CoreBound_small</queryRef>
                            <derivedQuery id="MemBoundGroup">
                                <queryInherit>/MemBound_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemBoundGroupExpanded">
                                        <queryRef>/StoresBound_small</queryRef>
                                        <derivedQuery id="L1BoundGroup">
                                            <queryInherit>/L1Bound_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L1BoundGroupExpanded">
                                                    <queryRef>/LoadsBlockedbyStoreForwarding_small</queryRef>
                                                    <queryRef>/Load_STLB_Hit_small</queryRef>
                                                    <queryRef>/Load_STLB_Miss_small</queryRef>
                                                    <queryRef>/OtherL1_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/L2Bound_small</queryRef>
                                        <queryRef>/L3Bound_small</queryRef>
                                        <queryRef>/DRAMBound_small</queryRef>
                                        <queryRef>/OtherLoadStore_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundAuxGroup">
                    <queryInherit>/BackendBoundAux_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundAuxGroupExpanded">
                            <derivedQuery id="ResourceBoundGroup">
                                <queryInherit>/ResourceBound_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="ResourceBoundGroupExpanded">
                                        <derivedQuery id="MemorySchedulerGroup">
                                            <queryInherit>/MemoryScheduler_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MemorySchedulerGroupExpanded">
                                                    <queryRef>/STBuffer_small</queryRef>
                                                    <queryRef>/LDBuffer_small</queryRef>
                                                    <queryRef>/RSV_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/NonMemoryScheduler_small</queryRef>
                                        <queryRef>/BERegister_small</queryRef>
                                        <queryRef>/BEReorderBuffer_small</queryRef>
                                        <queryRef>/BEAllocRestriction_small</queryRef>
                                        <queryRef>/Serializing_Operation_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots_small") >0.75 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="BASE_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") ) / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BASEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BASE_small") >0.60 ) ) && ( ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.60 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FP_Arith_small") >0.20 ) ) && ( ( query("/BASE_small") >0.60 ) && ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="OTHER_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") ) / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OTHER_small") >0.30 ) ) && ( ( query("/BASE_small") >0.60 ) && ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MicroSequencer_small") >0.05 ) ) && ( ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FELatency_small") >0.15 ) ) && ( ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ICacheMisses_small") >0.05 ) ) && ( ( query("/FELatency_small") >0.15 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ITLBOverhead_small") >0.05 ) ) && ( ( query("/FELatency_small") >0.15 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="BACLEARS_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BACLEARS_small") >0.05 ) ) && ( ( query("/FELatency_small") >0.15 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BranchResteers_small") >0.05 ) ) && ( ( query("/FELatency_small") >0.15 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidth_small") >0.10 ) ) && ( ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="FEBandwidthCisc_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidthCisc_small") >0.05 ) ) && ( ( query("/FEBandwidth_small") >0.10 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="FEBandwidthDecode_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidthDecode_small") >0.05 ) ) && ( ( query("/FEBandwidth_small") >0.10 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="PreDecodeWrong_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/PreDecodeWrong_small") >0.05 ) ) && ( ( query("/FEBandwidth_small") >0.10 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="FEOther_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEOther_small") >0.05 ) ) && ( ( query("/FEBandwidth_small") >0.10 ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_small") >0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BranchMispredict_small") >0.05 ) ) && ( ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MachineClears_small") >0.05 ) ) && ( ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="MachineClearsNuke_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclearsnuke_machineclearsnukedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MachineClearsNuke_small") >0.05 ) ) && ( ( query("/MachineClears_small") >0.05 ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SMCMachineClear" id="SMCMachineClear_small">
                    <description>%SMCMachineClearDescriptionAll</description>
                    <helpKeyword>configs.smcmachineclear_smcmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_small") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SMC]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%SMCMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/SMCMachineClear_small") >0.02 ) ) && ( ( query("/MachineClearsNuke_small") >0.05 ) && ( query("/MachineClears_small") >0.05 ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SMC]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MOMachineClear" id="MOMachineClear_small">
                    <description>%MOMachineClearDescriptionAll</description>
                    <helpKeyword>configs.momachineclear_momachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_small") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%MOMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MOMachineClear_small") >0.02 ) ) && ( ( query("/MachineClearsNuke_small") >0.05 ) && ( query("/MachineClears_small") >0.05 ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FPAssistMachineClear" id="FPAssistMachineClear_small">
                    <description>%FPAssistMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fpassistmachineclear_fpassistmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_small") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%FPAssistMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FPAssistMachineClear_small") >0.02 ) ) && ( ( query("/MachineClearsNuke_small") >0.05 ) && ( query("/MachineClears_small") >0.05 ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Disambiguation" id="Disambiguation_small">
                    <description>%DisambiguationDescriptionAll</description>
                    <helpKeyword>configs.disambiguation_disambiguationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_small") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%DisambiguationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Disambiguation_small") >0.02 ) ) && ( ( query("/MachineClearsNuke_small") >0.05 ) && ( query("/MachineClears_small") >0.05 ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PageFaultMachineClear" id="PageFaultMachineClear_small">
                    <description>%PageFaultMachineClearDescriptionAll</description>
                    <helpKeyword>configs.pagefaultmachineclear_pagefaultmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_small") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%PageFaultMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/PageFaultMachineClear_small") >0.02 ) ) && ( ( query("/MachineClearsNuke_small") >0.05 ) && ( query("/MachineClears_small") >0.05 ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FastMachineClear" id="FastMachineClear_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FastMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fastmachineclear_fastmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FastMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FastMachineClear_small") >0.05 ) ) && ( ( query("/MachineClears_small") >0.05 ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound_small") >0.10 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound_small") - query("/MemBound_small") if query("/BackendBound_small") - query("/MemBound_small") > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/CoreBound_small") >0.10 ) ) && ( ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) if ( ( ( query("/BackendBound_small") - query("/MemBound_small") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) if ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) < ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) else ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MemBound_small") >0.20 ) ) && ( ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_small") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/StoresBound_small") >0.10 ) ) && ( ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L1Bound_small") >0.10 ) ) && ( ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="LoadsBlockedbyStoreForwarding_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/LoadsBlockedbyStoreForwarding_small") >0.05 ) ) && ( ( query("/L1Bound_small") >0.10 ) && ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="Load_STLB_Hit_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_STLB_Hit_small") >0.05 ) ) && ( ( query("/L1Bound_small") >0.10 ) && ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="Load_STLB_Miss_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_STLB_Miss_small") >0.05 ) ) && ( ( query("/L1Bound_small") >0.10 ) && ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherL1" id="OtherL1_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%OtherL1DescriptionAll</description>
                    <helpKeyword>configs.otherl1_otherl1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.OTHER_AT_RET]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) ]]></valueEval>
                    <issueText>%OtherL1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OtherL1_small") >0.05 ) ) && ( ( query("/L1Bound_small") >0.10 ) && ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.OTHER_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_small") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L2Bound_small") >0.10 ) ) && ( ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_small") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L3Bound_small") >0.10 ) ) && ( ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_small") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/DRAMBound_small") >0.10 ) ) && ( ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherLoadStore" id="OtherLoadStore_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%OtherLoadStoreDescriptionAll</description>
                    <helpKeyword>configs.otherloadstore_otherloadstoredescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound_small") - ( query("/StoresBound_small") + query("/L1Bound_small") + query("/L2Bound_small") + query("/L3Bound_small") + query("/DRAMBound_small") ) if query("/MemBound_small") - ( query("/StoresBound_small") + query("/L1Bound_small") + query("/L2Bound_small") + query("/L3Bound_small") + query("/DRAMBound_small") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%OtherLoadStoreIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OtherLoadStore_small") >0.10 ) ) && ( ( query("/MemBound_small") >0.20 ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) if ( ( ( query("/MemBound_small") - ( ( ( ( query("/StoresBound_small") + query("/L1Bound_small") ) + query("/L2Bound_small") ) + query("/L3Bound_small") ) + query("/DRAMBound_small") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBoundAux" id="BackendBoundAux_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundAuxDescriptionAll</description>
                    <helpKeyword>configs.backendboundaux_backendboundauxdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound_small") ) ]]></valueEval>
                    <issueText>%BackendBoundAuxIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBoundAux_small") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ResourceBound" id="ResourceBound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ResourceBoundDescriptionAll</description>
                    <helpKeyword>configs.resourcebound_resourcebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound_small") ) ]]></valueEval>
                    <issueText>%ResourceBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ResourceBound_small") >0.20 ) ) && ( ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemoryScheduler" id="MemoryScheduler_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.memoryscheduler_memoryschedulerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%MemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MemoryScheduler_small") >0.10 ) ) && ( ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%STBuffer" id="STBuffer_small">
                    <description>%STBufferDescriptionAll</description>
                    <helpKeyword>configs.stbuffer_stbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_small") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%STBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/STBuffer_small") >0.05 ) ) && ( ( query("/MemoryScheduler_small") >0.10 ) && ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LDBuffer" id="LDBuffer_small">
                    <description>%LDBufferDescriptionAll</description>
                    <helpKeyword>configs.ldbuffer_ldbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_small") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%LDBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/LDBuffer_small") >0.05 ) ) && ( ( query("/MemoryScheduler_small") >0.10 ) && ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RSV" id="RSV_small">
                    <description>%RSVDescriptionAll</description>
                    <helpKeyword>configs.rsv_rsvdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_small") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%RSVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/RSV_small") >0.05 ) ) && ( ( query("/MemoryScheduler_small") >0.10 ) && ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%NonMemoryScheduler" id="NonMemoryScheduler_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%NonMemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.nonmemoryscheduler_nonmemoryschedulerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%NonMemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/NonMemoryScheduler_small") >0.10 ) ) && ( ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BERegister" id="BERegister_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BERegisterDescriptionAll</description>
                    <helpKeyword>configs.beregister_beregisterdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BERegisterIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BERegister_small") >0.10 ) ) && ( ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEReorderBuffer" id="BEReorderBuffer_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEReorderBufferDescriptionAll</description>
                    <helpKeyword>configs.bereorderbuffer_bereorderbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BEReorderBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BEReorderBuffer_small") >0.10 ) ) && ( ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="BEAllocRestriction_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BEAllocRestriction_small") >0.10 ) ) && ( ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Serializing_Operation_small") >0.10 ) ) && ( ( query("/ResourceBound_small") >0.20 ) && ( query("/BackendBoundAux_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width_small") * query("/DerivedClockticks_small") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width_small">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 6 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_BOUND_STALLS_AT_RET_CORRECTION" id="MEM_BOUND_STALLS_AT_RET_CORRECTION_small">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_BOUND_STALLS_AT_RET_CORRECTIONDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_stalls_at_ret_correction_mem_bound_stalls_at_ret_correctiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") - query("/PMUEventCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") if ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") - query("/PMUEventCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") > 0 else 0 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown_small" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBASEGroup">
                                            <queryInherit>/locatorBASE_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBASEGroupExpanded">
                                                    <queryRef>/locatorFP_Arith_small</queryRef>
                                                    <queryRef>/locatorOTHER_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/locatorMicroSequencer_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>/locatorFELatency_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses_small</queryRef>
                                                    <queryRef>/locatorITLBOverhead_small</queryRef>
                                                    <queryRef>/locatorBACLEARS_small</queryRef>
                                                    <queryRef>/locatorBranchResteers_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>/locatorFEBandwidth_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <queryRef>/locatorFEBandwidthCisc_small</queryRef>
                                                    <queryRef>/locatorFEBandwidthDecode_small</queryRef>
                                                    <queryRef>/locatorPreDecodeWrong_small</queryRef>
                                                    <queryRef>/locatorFEOther_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <queryRef>/locatorBranchMispredict_small</queryRef>
                                        <derivedQuery id="locatorMachineClearsGroup">
                                            <queryInherit>/locatorMachineClears_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMachineClearsGroupExpanded">
                                                    <derivedQuery id="locatorMachineClearsNukeGroup">
                                                        <queryInherit>/locatorMachineClearsNuke_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMachineClearsNukeGroupExpanded">
                                                                <queryRef>/locatorSMCMachineClear_small</queryRef>
                                                                <queryRef>/locatorMOMachineClear_small</queryRef>
                                                                <queryRef>/locatorFPAssistMachineClear_small</queryRef>
                                                                <queryRef>/locatorDisambiguation_small</queryRef>
                                                                <queryRef>/locatorPageFaultMachineClear_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorFastMachineClear_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <queryRef>/locatorCoreBound_small</queryRef>
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>/locatorMemBound_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <queryRef>/locatorStoresBound_small</queryRef>
                                                    <derivedQuery id="locatorL1BoundGroup">
                                                        <queryInherit>/locatorL1Bound_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL1BoundGroupExpanded">
                                                                <queryRef>/locatorLoadsBlockedbyStoreForwarding_small</queryRef>
                                                                <queryRef>/locatorLoad_STLB_Hit_small</queryRef>
                                                                <queryRef>/locatorLoad_STLB_Miss_small</queryRef>
                                                                <queryRef>/locatorOtherL1_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorL2Bound_small</queryRef>
                                                    <queryRef>/locatorL3Bound_small</queryRef>
                                                    <queryRef>/locatorDRAMBound_small</queryRef>
                                                    <queryRef>/locatorOtherLoadStore_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundAuxGroup">
                                <queryInherit>/locatorBackendBoundAux_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundAuxGroupExpanded">
                                        <derivedQuery id="locatorResourceBoundGroup">
                                            <queryInherit>/locatorResourceBound_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorResourceBoundGroupExpanded">
                                                    <derivedQuery id="locatorMemorySchedulerGroup">
                                                        <queryInherit>/locatorMemoryScheduler_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMemorySchedulerGroupExpanded">
                                                                <queryRef>/locatorSTBuffer_small</queryRef>
                                                                <queryRef>/locatorLDBuffer_small</queryRef>
                                                                <queryRef>/locatorRSV_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorNonMemoryScheduler_small</queryRef>
                                                    <queryRef>/locatorBERegister_small</queryRef>
                                                    <queryRef>/locatorBEReorderBuffer_small</queryRef>
                                                    <queryRef>/locatorBEAllocRestriction_small</queryRef>
                                                    <queryRef>/locatorSerializing_Operation_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/RetiredPipelineSlots_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") >0.75 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="locatorBASE_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BASE_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BASEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBASE") >0.60 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Arith_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Arith") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="locatorOTHER_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/OTHER_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOTHER") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MicroSequencer_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMicroSequencer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FrontendBoundPipelineSlots_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FELatency_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFELatency") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ICacheMisses_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ITLBOverhead_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="locatorBACLEARS_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BACLEARS_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBACLEARS") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchResteers_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidth_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidth") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="locatorFEBandwidthCisc_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthCisc_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthCisc") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="locatorFEBandwidthDecode_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDecode_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDecode") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="locatorPreDecodeWrong_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PreDecodeWrong_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPreDecodeWrong") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="locatorFEOther_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEOther_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEOther") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchMispredict_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClears_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="locatorMachineClearsNuke_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclearsnuke_machineclearsnukedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClearsNuke_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClearsNuke") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SMCMachineClear" id="locatorSMCMachineClear_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SMCMachineClearDescriptionAll</description>
                    <helpKeyword>configs.smcmachineclear_smcmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SMC]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SMCMachineClear_small") ) ]]></valueEval>
                    <issueText>%SMCMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSMCMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MOMachineClear" id="locatorMOMachineClear_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MOMachineClearDescriptionAll</description>
                    <helpKeyword>configs.momachineclear_momachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MOMachineClear_small") ) ]]></valueEval>
                    <issueText>%MOMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMOMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FPAssistMachineClear" id="locatorFPAssistMachineClear_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FPAssistMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fpassistmachineclear_fpassistmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FPAssistMachineClear_small") ) ]]></valueEval>
                    <issueText>%FPAssistMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFPAssistMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Disambiguation" id="locatorDisambiguation_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DisambiguationDescriptionAll</description>
                    <helpKeyword>configs.disambiguation_disambiguationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Disambiguation_small") ) ]]></valueEval>
                    <issueText>%DisambiguationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDisambiguation") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PageFaultMachineClear" id="locatorPageFaultMachineClear_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PageFaultMachineClearDescriptionAll</description>
                    <helpKeyword>configs.pagefaultmachineclear_pagefaultmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/PageFaultMachineClear_small") ) ]]></valueEval>
                    <issueText>%PageFaultMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPageFaultMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FastMachineClear" id="locatorFastMachineClear_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FastMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fastmachineclear_fastmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FastMachineClear_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FastMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFastMachineClear") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) if ( ( ( query("/BackendBound_small") - query("/MemBound_small") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/CoreBound_small") ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound_small") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/StoresBound_small") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L1Bound_small") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="locatorLoadsBlockedbyStoreForwarding_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LoadsBlockedbyStoreForwarding_small") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoadsBlockedbyStoreForwarding") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="locatorLoad_STLB_Hit_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Load_STLB_Hit_small") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Hit") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="locatorLoad_STLB_Miss_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Load_STLB_Miss_small") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Miss") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherL1" id="locatorOtherL1_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OtherL1DescriptionAll</description>
                    <helpKeyword>configs.otherl1_otherl1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.OTHER_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/OtherL1_small") ) ]]></valueEval>
                    <issueText>%OtherL1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOtherL1") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2Bound_small") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L3Bound_small") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/DRAMBound_small") ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDRAMBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherLoadStore" id="locatorOtherLoadStore_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OtherLoadStoreDescriptionAll</description>
                    <helpKeyword>configs.otherloadstore_otherloadstoredescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") ) + query("/StoresBound_small") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) if ( ( ( query("/MemBound_small") - ( ( ( ( query("/StoresBound_small") + query("/L1Bound_small") ) + query("/L2Bound_small") ) + query("/L3Bound_small") ) + query("/DRAMBound_small") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/OtherLoadStore_small") ) ]]></valueEval>
                    <issueText>%OtherLoadStoreIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOtherLoadStore") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBoundAux" id="locatorBackendBoundAux_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundAuxDescriptionAll</description>
                    <helpKeyword>configs.backendboundaux_backendboundauxdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBoundAux_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BackendBoundAuxIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBoundAux") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ResourceBound" id="locatorResourceBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ResourceBoundDescriptionAll</description>
                    <helpKeyword>configs.resourcebound_resourcebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ResourceBound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%ResourceBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorResourceBound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemoryScheduler" id="locatorMemoryScheduler_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.memoryscheduler_memoryschedulerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MemoryScheduler_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%MemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemoryScheduler") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%STBuffer" id="locatorSTBuffer_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%STBufferDescriptionAll</description>
                    <helpKeyword>configs.stbuffer_stbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/STBuffer_small") ) ]]></valueEval>
                    <issueText>%STBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSTBuffer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LDBuffer" id="locatorLDBuffer_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LDBufferDescriptionAll</description>
                    <helpKeyword>configs.ldbuffer_ldbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LDBuffer_small") ) ]]></valueEval>
                    <issueText>%LDBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLDBuffer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%RSV" id="locatorRSV_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RSVDescriptionAll</description>
                    <helpKeyword>configs.rsv_rsvdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/RSV_small") ) ]]></valueEval>
                    <issueText>%RSVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRSV") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%NonMemoryScheduler" id="locatorNonMemoryScheduler_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%NonMemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.nonmemoryscheduler_nonmemoryschedulerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/NonMemoryScheduler_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%NonMemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNonMemoryScheduler") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BERegister" id="locatorBERegister_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BERegisterDescriptionAll</description>
                    <helpKeyword>configs.beregister_beregisterdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BERegister_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BERegisterIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBERegister") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BEReorderBuffer" id="locatorBEReorderBuffer_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BEReorderBufferDescriptionAll</description>
                    <helpKeyword>configs.bereorderbuffer_bereorderbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BEReorderBuffer_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BEReorderBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBEReorderBuffer") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="locatorBEAllocRestriction_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BEAllocRestriction_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBEAllocRestriction") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Serializing_Operation_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="locatorSLOTS_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SLOTS_small") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="locatorPipeline_Width_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width_small") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_BOUND_STALLS_AT_RET_CORRECTION" id="locatorMEM_BOUND_STALLS_AT_RET_CORRECTION_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_BOUND_STALLS_AT_RET_CORRECTIONDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_stalls_at_ret_correction_mem_bound_stalls_at_ret_correctiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[E-Core]") ) ) / query("/DerivedClockticks_small") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_small") ) ]]></valueEval>
                </derivedQuery>
            </locatorqueryLibrary>
        </bag>
    </xsl:template>
    <xsl:variable name="isHTOn" select="exsl:ctx('isHTEnabled', 0) or (exsl:ctx('logicalCPUCount', 1) &gt; exsl:ctx('physicalCoreCount', 1))" />
    <xsl:variable name="is3DXOn" select="exsl:ctx('is3DXPPresent', 0) and not(exsl:ctx('is3DXP2LMMode', 0))" />
</xsl:stylesheet>
