/*
 * Decompiled with CFR 0.152.
 */
package antlr.debug;

import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.debug.InputBufferEventSupport;
import antlr.debug.InputBufferListener;
import java.util.Vector;

public class DebuggingInputBuffer
extends InputBuffer {
    private InputBuffer buffer;
    private InputBufferEventSupport inputBufferEventSupport;
    private boolean debugMode = true;

    public DebuggingInputBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
        this.inputBufferEventSupport = new InputBufferEventSupport(this);
    }

    public void addInputBufferListener(InputBufferListener inputBufferListener) {
        this.inputBufferEventSupport.addInputBufferListener(inputBufferListener);
    }

    public void consume() {
        char c15 = ' ';
        try {
            c15 = this.buffer.LA(1);
        }
        catch (CharStreamException charStreamException) {
            // empty catch block
        }
        this.buffer.consume();
        if (this.debugMode) {
            this.inputBufferEventSupport.fireConsume(c15);
        }
    }

    public void fill(int n15) throws CharStreamException {
        this.buffer.fill(n15);
    }

    public Vector getInputBufferListeners() {
        return this.inputBufferEventSupport.getInputBufferListeners();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isMarked() {
        return this.buffer.isMarked();
    }

    public char LA(int n15) throws CharStreamException {
        char c15 = this.buffer.LA(n15);
        if (this.debugMode) {
            this.inputBufferEventSupport.fireLA(c15, n15);
        }
        return c15;
    }

    public int mark() {
        int n15 = this.buffer.mark();
        this.inputBufferEventSupport.fireMark(n15);
        return n15;
    }

    public void removeInputBufferListener(InputBufferListener inputBufferListener) {
        if (this.inputBufferEventSupport != null) {
            this.inputBufferEventSupport.removeInputBufferListener(inputBufferListener);
        }
    }

    public void rewind(int n15) {
        this.buffer.rewind(n15);
        this.inputBufferEventSupport.fireRewind(n15);
    }

    public void setDebugMode(boolean bl4) {
        this.debugMode = bl4;
    }
}

