/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.smali;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiteralTools {
    private static Pattern specialFloatRegex = Pattern.compile("((-)?infinityf)|(nanf)", 2);
    private static Pattern specialDoubleRegex = Pattern.compile("((-)?infinityd?)|(nand?)", 2);

    public static byte parseByte(String byteLiteral) throws NumberFormatException {
        if (byteLiteral == null) {
            throw new NumberFormatException("string is null");
        }
        if (byteLiteral.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] byteChars = byteLiteral.toUpperCase().endsWith("T") ? byteLiteral.substring(0, byteLiteral.length() - 1).toCharArray() : byteLiteral.toCharArray();
        int position = 0;
        int radix = 10;
        boolean negative = false;
        if (byteChars[position] == '-') {
            ++position;
            negative = true;
        }
        if (byteChars[position] == '0') {
            if (++position == byteChars.length) {
                return 0;
            }
            if (byteChars[position] == 'x' || byteChars[position] == 'X') {
                radix = 16;
                ++position;
            } else if (Character.digit(byteChars[position], 8) >= 0) {
                radix = 8;
            }
        }
        byte result = 0;
        byte maxValue = (byte)(127 / (radix / 2));
        while (position < byteChars.length) {
            int digit = Character.digit(byteChars[position], radix);
            if (digit < 0) {
                throw new NumberFormatException("The string contains invalid an digit - '" + byteChars[position] + "'");
            }
            byte shiftedResult = (byte)(result * radix);
            if (result > maxValue) {
                throw new NumberFormatException(byteLiteral + " cannot fit into a byte");
            }
            if (shiftedResult < 0 && shiftedResult >= -digit) {
                throw new NumberFormatException(byteLiteral + " cannot fit into a byte");
            }
            result = (byte)(shiftedResult + digit);
            ++position;
        }
        if (negative) {
            if (result == -128) {
                return result;
            }
            if (result < 0) {
                throw new NumberFormatException(byteLiteral + " cannot fit into a byte");
            }
            return (byte)(result * -1);
        }
        return result;
    }

    public static short parseShort(String shortLiteral) throws NumberFormatException {
        if (shortLiteral == null) {
            throw new NumberFormatException("string is null");
        }
        if (shortLiteral.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] shortChars = shortLiteral.toUpperCase().endsWith("S") ? shortLiteral.substring(0, shortLiteral.length() - 1).toCharArray() : shortLiteral.toCharArray();
        int position = 0;
        int radix = 10;
        boolean negative = false;
        if (shortChars[position] == '-') {
            ++position;
            negative = true;
        }
        if (shortChars[position] == '0') {
            if (++position == shortChars.length) {
                return 0;
            }
            if (shortChars[position] == 'x' || shortChars[position] == 'X') {
                radix = 16;
                ++position;
            } else if (Character.digit(shortChars[position], 8) >= 0) {
                radix = 8;
            }
        }
        short result = 0;
        short maxValue = (short)(Short.MAX_VALUE / (radix / 2));
        while (position < shortChars.length) {
            int digit = Character.digit(shortChars[position], radix);
            if (digit < 0) {
                throw new NumberFormatException("The string contains invalid an digit - '" + shortChars[position] + "'");
            }
            short shiftedResult = (short)(result * radix);
            if (result > maxValue) {
                throw new NumberFormatException(shortLiteral + " cannot fit into a short");
            }
            if (shiftedResult < 0 && shiftedResult >= -digit) {
                throw new NumberFormatException(shortLiteral + " cannot fit into a short");
            }
            result = (short)(shiftedResult + digit);
            ++position;
        }
        if (negative) {
            if (result == Short.MIN_VALUE) {
                return result;
            }
            if (result < 0) {
                throw new NumberFormatException(shortLiteral + " cannot fit into a short");
            }
            return (short)(result * -1);
        }
        return result;
    }

    public static int parseInt(String intLiteral) throws NumberFormatException {
        if (intLiteral == null) {
            throw new NumberFormatException("string is null");
        }
        if (intLiteral.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] intChars = intLiteral.toCharArray();
        int position = 0;
        int radix = 10;
        boolean negative = false;
        if (intChars[position] == '-') {
            ++position;
            negative = true;
        }
        if (intChars[position] == '0') {
            if (++position == intChars.length) {
                return 0;
            }
            if (intChars[position] == 'x' || intChars[position] == 'X') {
                radix = 16;
                ++position;
            } else if (Character.digit(intChars[position], 8) >= 0) {
                radix = 8;
            }
        }
        int result = 0;
        int maxValue = Integer.MAX_VALUE / (radix / 2);
        while (position < intChars.length) {
            int digit = Character.digit(intChars[position], radix);
            if (digit < 0) {
                throw new NumberFormatException("The string contains an invalid digit - '" + intChars[position] + "'");
            }
            int shiftedResult = result * radix;
            if (result > maxValue) {
                throw new NumberFormatException(intLiteral + " cannot fit into an int");
            }
            if (shiftedResult < 0 && shiftedResult >= -digit) {
                throw new NumberFormatException(intLiteral + " cannot fit into an int");
            }
            result = shiftedResult + digit;
            ++position;
        }
        if (negative) {
            if (result == Integer.MIN_VALUE) {
                return result;
            }
            if (result < 0) {
                throw new NumberFormatException(intLiteral + " cannot fit into an int");
            }
            return result * -1;
        }
        return result;
    }

    public static long parseLong(String longLiteral) throws NumberFormatException {
        if (longLiteral == null) {
            throw new NumberFormatException("string is null");
        }
        if (longLiteral.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] longChars = longLiteral.toUpperCase().endsWith("L") ? longLiteral.substring(0, longLiteral.length() - 1).toCharArray() : longLiteral.toCharArray();
        int position = 0;
        int radix = 10;
        boolean negative = false;
        if (longChars[position] == '-') {
            ++position;
            negative = true;
        }
        if (longChars[position] == '0') {
            if (++position == longChars.length) {
                return 0L;
            }
            if (longChars[position] == 'x' || longChars[position] == 'X') {
                radix = 16;
                ++position;
            } else if (Character.digit(longChars[position], 8) >= 0) {
                radix = 8;
            }
        }
        long result = 0L;
        long maxValue = Long.MAX_VALUE / (long)(radix / 2);
        while (position < longChars.length) {
            int digit = Character.digit(longChars[position], radix);
            if (digit < 0) {
                throw new NumberFormatException("The string contains an invalid digit - '" + longChars[position] + "'");
            }
            long shiftedResult = result * (long)radix;
            if (result > maxValue) {
                throw new NumberFormatException(longLiteral + " cannot fit into a long");
            }
            if (shiftedResult < 0L && shiftedResult >= (long)(-digit)) {
                throw new NumberFormatException(longLiteral + " cannot fit into a long");
            }
            result = shiftedResult + (long)digit;
            ++position;
        }
        if (negative) {
            if (result == Long.MIN_VALUE) {
                return result;
            }
            if (result < 0L) {
                throw new NumberFormatException(longLiteral + " cannot fit into a long");
            }
            return result * -1L;
        }
        return result;
    }

    public static float parseFloat(String floatString) {
        Matcher m15 = specialFloatRegex.matcher(floatString);
        if (m15.matches()) {
            if (m15.start(1) != -1) {
                if (m15.start(2) != -1) {
                    return Float.NEGATIVE_INFINITY;
                }
                return Float.POSITIVE_INFINITY;
            }
            return Float.NaN;
        }
        return Float.parseFloat(floatString);
    }

    public static double parseDouble(String doubleString) {
        Matcher m15 = specialDoubleRegex.matcher(doubleString);
        if (m15.matches()) {
            if (m15.start(1) != -1) {
                if (m15.start(2) != -1) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        return Double.parseDouble(doubleString);
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        int i15 = 0;
        while (value != 0L) {
            bytes[i15] = (byte)value;
            value >>>= 8;
            ++i15;
        }
        return bytes;
    }

    public static byte[] intToBytes(int value) {
        byte[] bytes = new byte[4];
        int i15 = 0;
        while (value != 0) {
            bytes[i15] = (byte)value;
            value >>>= 8;
            ++i15;
        }
        return bytes;
    }

    public static byte[] shortToBytes(short value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8)};
        return bytes;
    }

    public static byte[] floatToBytes(float value) {
        return LiteralTools.intToBytes(Float.floatToRawIntBits(value));
    }

    public static byte[] doubleToBytes(double value) {
        return LiteralTools.longToBytes(Double.doubleToRawLongBits(value));
    }

    public static byte[] charToBytes(char value) {
        return LiteralTools.shortToBytes((short)value);
    }

    public static byte[] boolToBytes(boolean value) {
        if (value) {
            return new byte[]{1};
        }
        return new byte[]{0};
    }

    public static void checkInt(long value) {
        if (value > -1L || value < Integer.MIN_VALUE) {
            throw new NumberFormatException(Long.toString(value) + " cannot fit into an int");
        }
    }

    public static void checkShort(long value) {
        if (value > 65535L | value < -32768L) {
            throw new NumberFormatException(Long.toString(value) + " cannot fit into a short");
        }
    }

    public static void checkByte(long value) {
        if (value > 255L | value < -128L) {
            throw new NumberFormatException(Long.toString(value) + " cannot fit into a byte");
        }
    }

    public static void checkNibble(long value) {
        if (value > 15L | value < -8L) {
            throw new NumberFormatException(Long.toString(value) + " cannot fit into a nibble");
        }
    }
}

