/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.smali;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.android.tools.smali.dexlib2.writer.io.MemoryDataStore;
import com.android.tools.smali.smali.smaliFlexLexer;
import com.android.tools.smali.smali.smaliParser;
import com.android.tools.smali.smali.smaliTreeWalker;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.StringReader;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;

public class SmaliTestUtils {
    public static DexBackedClassDef compileSmali(String smaliText) throws RecognitionException, IOException {
        return SmaliTestUtils.compileSmali(smaliText, 15);
    }

    public static DexBackedClassDef compileSmali(String smaliText, int apiLevel) throws RecognitionException, IOException {
        DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi(apiLevel));
        StringReader reader = new StringReader(smaliText);
        smaliFlexLexer lexer = new smaliFlexLexer(reader, apiLevel);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        smaliParser parser = new smaliParser(tokens);
        parser.setVerboseErrors(true);
        parser.setAllowOdex(false);
        parser.setApiLevel(apiLevel);
        smaliParser.smali_file_return result = parser.smali_file();
        if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
            throw new RuntimeException("Error occurred while compiling text");
        }
        CommonTree t15 = result.getTree();
        CommonTreeNodeStream treeStream = new CommonTreeNodeStream(t15);
        treeStream.setTokenStream(tokens);
        smaliTreeWalker dexGen = new smaliTreeWalker(treeStream);
        dexGen.setApiLevel(apiLevel);
        dexGen.setVerboseErrors(true);
        dexGen.setDexBuilder(dexBuilder);
        dexGen.smali_file();
        if (dexGen.getNumberOfSyntaxErrors() > 0) {
            throw new RuntimeException("Error occurred while compiling text");
        }
        MemoryDataStore dataStore = new MemoryDataStore();
        dexBuilder.writeTo(dataStore);
        DexBackedDexFile dexFile = new DexBackedDexFile(Opcodes.forApi(apiLevel), dataStore.getBuffer());
        return Iterables.getFirst(dexFile.getClasses(), null);
    }
}

