/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class PathUtil {
    private PathUtil() {
    }

    public static File getRelativeFile(File baseFile, File fileToRelativize) throws IOException {
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return new File(PathUtil.getRelativeFileInternal(baseFile.getCanonicalFile(), fileToRelativize.getCanonicalFile()));
    }

    static String getRelativeFileInternal(File canonicalBaseFile, File canonicalFileToRelativize) {
        int i15;
        List<String> basePath = PathUtil.getPathComponents(canonicalBaseFile);
        List<String> pathToRelativize = PathUtil.getPathComponents(canonicalFileToRelativize);
        if (!basePath.get(0).equals(pathToRelativize.get(0))) {
            return canonicalFileToRelativize.getPath();
        }
        StringBuilder sb5 = new StringBuilder();
        for (int commonDirs = 1; commonDirs < basePath.size() && commonDirs < pathToRelativize.size() && basePath.get(commonDirs).equals(pathToRelativize.get(commonDirs)); ++commonDirs) {
        }
        boolean first = true;
        for (i15 = commonDirs; i15 < basePath.size(); ++i15) {
            if (!first) {
                sb5.append(File.separatorChar);
            } else {
                first = false;
            }
            sb5.append("..");
        }
        first = true;
        for (i15 = commonDirs; i15 < pathToRelativize.size(); ++i15) {
            if (first) {
                if (sb5.length() != 0) {
                    sb5.append(File.separatorChar);
                }
                first = false;
            } else {
                sb5.append(File.separatorChar);
            }
            sb5.append(pathToRelativize.get(i15));
        }
        if (sb5.length() == 0) {
            return ".";
        }
        return sb5.toString();
    }

    private static List<String> getPathComponents(File file2) {
        ArrayList<String> path = new ArrayList<String>();
        while (file2 != null) {
            File parentFile = file2.getParentFile();
            if (parentFile == null) {
                path.add(file2.getPath());
            } else {
                path.add(file2.getName());
            }
            file2 = parentFile;
        }
        return Lists.reverse(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean testCaseSensitivity(File path) throws IOException {
        File f25;
        File f15;
        int num = 1;
        do {
            f15 = new File(path, "test." + num);
            f25 = new File(path, "TEST." + num++);
        } while (f15.exists() || f25.exists());
        try {
            try {
                FileWriter writer = new FileWriter(f15);
                writer.write("test");
                writer.flush();
                writer.close();
            }
            catch (IOException ex4) {
                try {
                    f15.delete();
                    throw ex4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex4;
            }
            if (f25.exists()) {
                boolean ex4 = false;
                return ex4;
            }
            if (f25.createNewFile()) {
                boolean ex4 = true;
                return ex4;
            }
            CharBuffer buf = CharBuffer.allocate(32);
            FileReader reader = new FileReader(f25);
            while (reader.read(buf) != -1 && buf.length() < 4) {
            }
            if (buf.length() == 4 && buf.toString().equals("test")) {
                boolean bl4 = false;
                return bl4;
            }
            assert (false);
            boolean bl5 = false;
            return bl5;
        }
        finally {
            try {
                f15.delete();
            }
            catch (Exception exception) {}
            try {
                f25.delete();
            }
            catch (Exception exception) {}
        }
    }
}

