/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.mesh;

import com.github.weisj.jsvg.geometry.mesh.CoonPatch;
import com.github.weisj.jsvg.geometry.mesh.CoonValues;
import com.github.weisj.jsvg.geometry.mesh.Subdivided;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.Stop;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.renderer.output.Output;
import com.github.weisj.jsvg.util.ColorUtil;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={})
@PermittedContent(categories={Category.Descriptive}, anyOf={Stop.class})
public final class MeshPatch
extends ContainerNode {
    public static final String TAG = "meshpatch";
    private static final int MAX_DEPTH = 10;
    Color north;
    Color east;
    Color south;
    Color west;
    @NotNull
    final CoonPatch coonPatch = CoonPatch.createUninitialized();

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public void renderPath(@NotNull Output output) {
        if (!output.supportsColors()) {
            output.fillShape(this.coonPatch.toShape());
            return;
        }
        AffineTransform at4 = output.transform();
        float scaleX = (float)GeometryUtil.scaleYOfTransform(at4);
        float scaleY = (float)GeometryUtil.scaleYOfTransform(at4);
        int depth = Math.max(Math.max(this.coonPatch.north.estimateStepCount(scaleX, scaleY), this.coonPatch.east.estimateStepCount(scaleX, scaleY)), Math.max(this.coonPatch.south.estimateStepCount(scaleX, scaleY), this.coonPatch.west.estimateStepCount(scaleX, scaleY)));
        this.renderPath(output, this.coonPatch, scaleX, scaleY, Math.min(10, depth));
    }

    private void renderPath(@NotNull Output output, @NotNull CoonPatch patch, float scaleX, float scaleY, int depth) {
        CoonValues weights = patch.coonValues;
        if (depth == 0 || GeometryUtil.distanceSquared(weights.north, weights.south, scaleX, scaleY) * GeometryUtil.distanceSquared(weights.east, weights.west, scaleX, scaleY) < 1.0E-6) {
            float u15 = (weights.north.x + weights.east.x + weights.south.x + weights.west.x) / 4.0f;
            float v15 = (weights.north.y + weights.east.y + weights.south.y + weights.west.y) / 4.0f;
            output.setPaint(this.bilinearInterpolation(u15, v15));
            Shape s15 = patch.toShape();
            output.fillShape(s15.getBounds2D());
        } else {
            Subdivided<CoonPatch> patchSubdivided = patch.subdivide();
            this.renderPath(output, (CoonPatch)patchSubdivided.northWest, scaleX, scaleY, depth - 1);
            this.renderPath(output, (CoonPatch)patchSubdivided.northEast, scaleX, scaleY, depth - 1);
            this.renderPath(output, (CoonPatch)patchSubdivided.southEast, scaleX, scaleY, depth - 1);
            this.renderPath(output, (CoonPatch)patchSubdivided.southWest, scaleX, scaleY, depth - 1);
        }
    }

    @NotNull
    private Color bilinearInterpolation(float dx4, float dy4) {
        float r15 = GeometryUtil.lerp(dy4, GeometryUtil.lerp(dx4, this.north.getRed(), this.east.getRed()), GeometryUtil.lerp(dx4, this.west.getRed(), this.south.getRed()));
        float g15 = GeometryUtil.lerp(dy4, GeometryUtil.lerp(dx4, this.north.getGreen(), this.east.getGreen()), GeometryUtil.lerp(dx4, this.west.getGreen(), this.south.getGreen()));
        float b15 = GeometryUtil.lerp(dy4, GeometryUtil.lerp(dx4, this.north.getBlue(), this.east.getBlue()), GeometryUtil.lerp(dx4, this.west.getBlue(), this.south.getBlue()));
        float a15 = GeometryUtil.lerp(dy4, GeometryUtil.lerp(dx4, this.north.getAlpha(), this.east.getAlpha()), GeometryUtil.lerp(dx4, this.west.getAlpha(), this.south.getAlpha()));
        return new Color(this.clampColor(r15), this.clampColor(g15), this.clampColor(b15), this.clampColor(a15));
    }

    private int clampColor(float v15) {
        return ColorUtil.clampColor((int)v15);
    }
}

