/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.paint.impl.jdk;

import com.github.weisj.jsvg.paint.impl.jdk.SVGMultipleGradientPaint;
import com.github.weisj.jsvg.util.ColorUtil;
import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

abstract class SVGMultipleGradientPaintContext
implements PaintContext {
    private static final float MIN_INTERVAL_LENGTH = 0.001f;
    protected ColorModel model;
    private static final ColorModel XRGB_MODEL = new DirectColorModel(24, 0xFF0000, 65280, 255);
    protected static ColorModel cachedModel;
    protected static WeakReference<Raster> cached;
    protected Raster saved;
    protected MultipleGradientPaint.CycleMethod cycleMethod;
    protected MultipleGradientPaint.ColorSpaceType colorSpace;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup;
    protected int fastGradientArraySize;
    protected int[] gradient;
    private int[][] gradients;
    private float[] normalizedIntervals;
    private final float[] fractions;
    private int transparencyTest;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    protected SVGMultipleGradientPaintContext(@NotNull SVGMultipleGradientPaint mgp, @NotNull AffineTransform t15, float @NotNull [] fractions, @NotNull @NotNull Color @NotNull [] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace) {
        int[][] grads;
        AffineTransform tInv;
        try {
            t15.invert();
            tInv = t15;
        }
        catch (NoninvertibleTransformException e15) {
            tInv = new AffineTransform();
        }
        double[] m15 = new double[6];
        tInv.getMatrix(m15);
        this.a00 = (float)m15[0];
        this.a10 = (float)m15[1];
        this.a01 = (float)m15[2];
        this.a11 = (float)m15[3];
        this.a02 = (float)m15[4];
        this.a12 = (float)m15[5];
        this.cycleMethod = cycleMethod;
        this.colorSpace = colorSpace;
        this.fractions = fractions;
        int[] grad = mgp.gradient != null ? mgp.gradient.get() : null;
        int[][] nArray = grads = mgp.gradients != null ? mgp.gradients.get() : null;
        if (grad == null && grads == null) {
            this.calculateLookupData(colors);
            mgp.model = this.model;
            mgp.normalizedIntervals = this.normalizedIntervals;
            mgp.isSimpleLookup = this.isSimpleLookup;
            if (this.isSimpleLookup) {
                mgp.fastGradientArraySize = this.fastGradientArraySize;
                mgp.gradient = new SoftReference<int[]>(this.gradient);
            } else {
                mgp.gradients = new SoftReference<int[][]>(this.gradients);
            }
        } else {
            this.model = mgp.model;
            this.normalizedIntervals = mgp.normalizedIntervals;
            this.isSimpleLookup = mgp.isSimpleLookup;
            this.gradient = grad;
            this.fastGradientArraySize = mgp.fastGradientArraySize;
            this.gradients = grads;
        }
    }

    private void calculateLookupData(Color[] colors) {
        int i15;
        Color[] normalizedColors;
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            normalizedColors = new Color[colors.length];
            for (i15 = 0; i15 < colors.length; ++i15) {
                int argb = colors[i15].getRGB();
                normalizedColors[i15] = new Color(ColorUtil.sRGBtoLinearRGB(argb), true);
            }
        } else {
            normalizedColors = colors;
        }
        this.normalizedIntervals = new float[this.fractions.length - 1];
        for (i15 = 0; i15 < this.normalizedIntervals.length; ++i15) {
            this.normalizedIntervals[i15] = this.fractions[i15 + 1] - this.fractions[i15];
        }
        this.transparencyTest = -16777216;
        this.gradients = new int[this.normalizedIntervals.length][];
        float minInterval = 1.0f;
        for (float interval : this.normalizedIntervals) {
            if (!(interval > 0.001f)) continue;
            minInterval = Math.min(minInterval, interval);
        }
        int estimatedSize = 0;
        for (float normalizedInterval : this.normalizedIntervals) {
            estimatedSize += (int)(normalizedInterval / minInterval * 256.0f);
        }
        if (estimatedSize > 5000) {
            this.calculateMultipleArrayGradient(normalizedColors);
        } else {
            this.calculateSingleArrayGradient(normalizedColors, minInterval);
        }
        this.model = this.transparencyTest >>> 24 == 255 ? XRGB_MODEL : ColorModel.getRGBdefault();
    }

    private void calculateSingleArrayGradient(Color[] colors, float minInterval) {
        this.isSimpleLookup = true;
        int gradientsTot = 1;
        for (int i15 = 0; i15 < this.gradients.length; ++i15) {
            int nGradients = (int)(this.normalizedIntervals[i15] / minInterval * 255.0f);
            gradientsTot += nGradients;
            this.gradients[i15] = new int[nGradients];
            int rgb1 = colors[i15].getRGB();
            int rgb2 = colors[i15 + 1].getRGB();
            this.interpolate(rgb1, rgb2, this.gradients[i15]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
        this.gradient = new int[gradientsTot];
        int curOffset = 0;
        for (int[] ints : this.gradients) {
            System.arraycopy(ints, 0, this.gradient, curOffset, ints.length);
            curOffset += ints.length;
        }
        this.gradient[this.gradient.length - 1] = colors[colors.length - 1].getRGB();
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            for (int i16 = 0; i16 < this.gradient.length; ++i16) {
                this.gradient[i16] = ColorUtil.linearRGBtoSRGB(this.gradient[i16]);
            }
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient(Color[] colors) {
        this.isSimpleLookup = false;
        for (int i15 = 0; i15 < this.gradients.length; ++i15) {
            this.gradients[i15] = new int[256];
            int rgb1 = colors[i15].getRGB();
            int rgb2 = colors[i15 + 1].getRGB();
            this.interpolate(rgb1, rgb2, this.gradients[i15]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            for (int j15 = 0; j15 < this.gradients.length; ++j15) {
                for (int i16 = 0; i16 < this.gradients[j15].length; ++i16) {
                    this.gradients[j15][i16] = ColorUtil.linearRGBtoSRGB(this.gradients[j15][i16]);
                }
            }
        }
    }

    private void interpolate(int rgb1, int rgb2, int[] output) {
        float stepSize = 1.0f / (float)output.length;
        int a15 = rgb1 >> 24 & 0xFF;
        int r15 = rgb1 >> 16 & 0xFF;
        int g15 = rgb1 >> 8 & 0xFF;
        int b15 = rgb1 & 0xFF;
        int da5 = (rgb2 >> 24 & 0xFF) - a15;
        int dr4 = (rgb2 >> 16 & 0xFF) - r15;
        int dg5 = (rgb2 >> 8 & 0xFF) - g15;
        int db5 = (rgb2 & 0xFF) - b15;
        for (int i15 = 0; i15 < output.length; ++i15) {
            output[i15] = (int)((double)((float)a15 + (float)(i15 * da5) * stepSize) + 0.5) << 24 | (int)((double)((float)r15 + (float)(i15 * dr4) * stepSize) + 0.5) << 16 | (int)((double)((float)g15 + (float)(i15 * dg5) * stepSize) + 0.5) << 8 | (int)((double)((float)b15 + (float)(i15 * db5) * stepSize) + 0.5);
        }
    }

    private static float mod1(float x15) {
        float result = x15 - (float)((int)x15);
        if (result < 0.0f) {
            result += 1.0f;
        }
        return result;
    }

    private static float mod1Reflect(float x15) {
        float result = Math.abs(x15);
        int part = (int)x15;
        result -= (float)part;
        if (part % 2 == 1) {
            result = 1.0f - result;
        }
        return result;
    }

    protected final int indexIntoGradientsArrays(float position) {
        position = this.cycleMethod == MultipleGradientPaint.CycleMethod.NO_CYCLE ? Math.min(1.0f, Math.max(0.0f, position)) : (this.cycleMethod == MultipleGradientPaint.CycleMethod.REPEAT ? SVGMultipleGradientPaintContext.mod1(position) : SVGMultipleGradientPaintContext.mod1Reflect(position));
        if (this.isSimpleLookup) {
            return this.gradient[(int)(position * (float)this.fastGradientArraySize)];
        }
        for (int i15 = 0; i15 < this.gradients.length; ++i15) {
            if (!(position < this.fractions[i15 + 1])) continue;
            float delta = position - this.fractions[i15];
            int index = (int)(delta / this.normalizedIntervals[i15] * 255.0f);
            return this.gradients[i15][index];
        }
        return this.gradients[this.gradients.length - 1][255];
    }

    @Override
    public final Raster getRaster(int x15, int y15, int w15, int h15) {
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < w15 || raster.getHeight() < h15) {
            this.saved = raster = SVGMultipleGradientPaintContext.getCachedRaster(this.model, w15, h15);
        }
        DataBufferInt rasterDB = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = rasterDB.getData(0);
        int off = rasterDB.getOffset();
        int scanlineStride = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int adjust = scanlineStride - w15;
        this.fillRaster(pixels, off, adjust, x15, y15, w15, h15);
        return raster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static synchronized Raster getCachedRaster(ColorModel cm4, int w15, int h15) {
        Raster ras;
        if (Objects.equals(cm4, cachedModel) && cached != null && (ras = (Raster)cached.get()) != null && ras.getWidth() >= w15 && ras.getHeight() >= h15) {
            cached = null;
            return ras;
        }
        return cm4.createCompatibleWritableRaster(w15, h15);
    }

    private static synchronized void putCachedRaster(ColorModel cm4, Raster ras) {
        Raster cras;
        if (cached != null && (cras = (Raster)cached.get()) != null) {
            int cw4 = cras.getWidth();
            int ch4 = cras.getHeight();
            int iw4 = ras.getWidth();
            int ih4 = ras.getHeight();
            if (cw4 >= iw4 && ch4 >= ih4) {
                return;
            }
            if (cw4 * ch4 >= iw4 * ih4) {
                return;
            }
        }
        cachedModel = cm4;
        cached = new WeakReference<Raster>(ras);
    }

    @Override
    public final void dispose() {
        if (this.saved != null) {
            SVGMultipleGradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    @Override
    public final ColorModel getColorModel() {
        return this.model;
    }
}

