/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractStreamingHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jspecify.annotations.Nullable;

@Immutable
final class Murmur3_128HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_128 = new Murmur3_128HashFunction(0);
    static final HashFunction GOOD_FAST_HASH_128 = new Murmur3_128HashFunction(Hashing.GOOD_FAST_HASH_SEED);
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_128HashFunction(int seed) {
        this.seed = seed;
    }

    @Override
    public int bits() {
        return 128;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_128Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_128(" + this.seed + ")";
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Murmur3_128HashFunction) {
            Murmur3_128HashFunction other = (Murmur3_128HashFunction)object;
            return this.seed == other.seed;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    private static final class Murmur3_128Hasher
    extends AbstractStreamingHasher {
        private static final int CHUNK_SIZE = 16;
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private long h1;
        private long h2;
        private int length;

        Murmur3_128Hasher(int seed) {
            super(16);
            this.h1 = seed;
            this.h2 = seed;
            this.length = 0;
        }

        @Override
        protected void process(ByteBuffer bb5) {
            long k15 = bb5.getLong();
            long k25 = bb5.getLong();
            this.bmix64(k15, k25);
            this.length += 16;
        }

        private void bmix64(long k15, long k25) {
            this.h1 ^= Murmur3_128Hasher.mixK1(k15);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            this.h2 ^= Murmur3_128Hasher.mixK2(k25);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        @Override
        protected void processRemaining(ByteBuffer bb5) {
            long k15 = 0L;
            long k25 = 0L;
            this.length += bb5.remaining();
            switch (bb5.remaining()) {
                case 15: {
                    k25 ^= (long)Byte.toUnsignedInt(bb5.get(14)) << 48;
                }
                case 14: {
                    k25 ^= (long)Byte.toUnsignedInt(bb5.get(13)) << 40;
                }
                case 13: {
                    k25 ^= (long)Byte.toUnsignedInt(bb5.get(12)) << 32;
                }
                case 12: {
                    k25 ^= (long)Byte.toUnsignedInt(bb5.get(11)) << 24;
                }
                case 11: {
                    k25 ^= (long)Byte.toUnsignedInt(bb5.get(10)) << 16;
                }
                case 10: {
                    k25 ^= (long)Byte.toUnsignedInt(bb5.get(9)) << 8;
                }
                case 9: {
                    k25 ^= (long)Byte.toUnsignedInt(bb5.get(8));
                }
                case 8: {
                    k15 ^= bb5.getLong();
                    break;
                }
                case 7: {
                    k15 ^= (long)Byte.toUnsignedInt(bb5.get(6)) << 48;
                }
                case 6: {
                    k15 ^= (long)Byte.toUnsignedInt(bb5.get(5)) << 40;
                }
                case 5: {
                    k15 ^= (long)Byte.toUnsignedInt(bb5.get(4)) << 32;
                }
                case 4: {
                    k15 ^= (long)Byte.toUnsignedInt(bb5.get(3)) << 24;
                }
                case 3: {
                    k15 ^= (long)Byte.toUnsignedInt(bb5.get(2)) << 16;
                }
                case 2: {
                    k15 ^= (long)Byte.toUnsignedInt(bb5.get(1)) << 8;
                }
                case 1: {
                    k15 ^= (long)Byte.toUnsignedInt(bb5.get(0));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            this.h1 ^= Murmur3_128Hasher.mixK1(k15);
            this.h2 ^= Murmur3_128Hasher.mixK2(k25);
        }

        @Override
        protected HashCode makeHash() {
            this.h1 ^= (long)this.length;
            this.h2 ^= (long)this.length;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = Murmur3_128Hasher.fmix64(this.h1);
            this.h2 = Murmur3_128Hasher.fmix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            return HashCode.fromBytesNoCopy(ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN).putLong(this.h1).putLong(this.h2).array());
        }

        private static long fmix64(long k15) {
            k15 ^= k15 >>> 33;
            k15 *= -49064778989728563L;
            k15 ^= k15 >>> 33;
            k15 *= -4265267296055464877L;
            k15 ^= k15 >>> 33;
            return k15;
        }

        private static long mixK1(long k15) {
            k15 *= -8663945395140668459L;
            k15 = Long.rotateLeft(k15, 31);
            return k15 *= 5545529020109919103L;
        }

        private static long mixK2(long k25) {
            k25 *= 5545529020109919103L;
            k25 = Long.rotateLeft(k25, 33);
            return k25 *= -8663945395140668459L;
        }
    }
}

