/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.Cache;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

final class MemoryCache
implements Cache {
    static final int BLOCK_SIZE = 8192;
    private static final byte[] NULL_BLOCK = new byte[0];
    private final List<byte[]> cache = new ArrayList<byte[]>();
    private final ReadableByteChannel channel;
    private int maxBlock = Integer.MAX_VALUE;
    private long length;
    private long position;
    private long start;

    MemoryCache(InputStream inputStream) {
        this(Channels.newChannel(Validate.notNull(inputStream, "stream")));
    }

    public MemoryCache(ReadableByteChannel readableByteChannel) {
        this.channel = Validate.notNull(readableByteChannel, "channel");
    }

    byte[] fetchBlock() throws IOException {
        long l15 = this.position;
        long l16 = l15 / 8192L;
        if (l16 >= Integer.MAX_VALUE) {
            throw new IOException("Memory cache max size exceeded");
        }
        if (l16 > (long)this.maxBlock) {
            return NULL_BLOCK;
        }
        while (l16 >= (long)this.cache.size()) {
            byte[] byArray;
            try {
                byArray = new byte[8192];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("No more memory for cache: " + this.cache.size() * 8192);
            }
            this.cache.add(byArray);
            int n15 = this.readBlock(byArray);
            this.length += (long)n15;
            if (n15 >= 8192) continue;
            this.maxBlock = (int)l16;
            return byArray;
        }
        return this.cache.get((int)l16);
    }

    private int readBlock(byte[] byArray) throws IOException {
        int n15;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        while (byteBuffer.hasRemaining() && (n15 = this.channel.read(byteBuffer)) != -1) {
        }
        return byteBuffer.position();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = this.fetchBlock();
        if (this.position >= this.length) {
            return -1;
        }
        int n15 = (int)(this.position % 8192L);
        int n16 = Math.min(byteBuffer.remaining(), (int)Math.min((long)(8192 - n15), this.length - this.position));
        byteBuffer.put(byArray, n15, n16);
        this.position += (long)n16;
        return n16;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long l15) throws IOException {
        if (l15 < this.start) {
            throw new IOException("Seek before flush position");
        }
        this.position = l15;
        return this;
    }

    @Override
    public long size() throws IOException {
        return -1L;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        throw new NonWritableChannelException();
    }

    @Override
    public SeekableByteChannel truncate(long l15) {
        throw new NonWritableChannelException();
    }

    @Override
    public void flushBefore(long l15) {
        if (l15 < this.start) {
            throw new IndexOutOfBoundsException("pos < flushed position");
        }
        if (l15 > this.position) {
            throw new IndexOutOfBoundsException("pos > current position");
        }
        int n15 = (int)(l15 / 8192L);
        for (int i15 = 0; i15 < n15; ++i15) {
            this.cache.set(i15, null);
        }
        this.start = l15;
    }
}

