/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.EmptyReader;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StringArrayReader
extends StringReader {
    private StringReader current;
    private String[] strings;
    protected final Object finalLock;
    private int currentSting;
    private int markedString;
    private long mark;
    private long next;

    public StringArrayReader(String[] stringArray) {
        super("");
        Validate.notNull(stringArray, "strings");
        this.lock = stringArray;
        this.finalLock = stringArray;
        this.strings = (String[])stringArray.clone();
        this.nextReader();
    }

    protected final Reader nextReader() {
        this.current = this.currentSting >= this.strings.length ? new EmptyReader() : new StringReader(this.strings[this.currentSting++]);
        this.next = 0L;
        return this.current;
    }

    protected final void ensureOpen() throws IOException {
        if (this.strings == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void close() {
        super.close();
        this.strings = null;
        this.current.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n15) throws IOException {
        if (n15 < 0) {
            throw new IllegalArgumentException("Read limit < 0");
        }
        Object object = this.finalLock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
            this.markedString = this.currentSting;
            this.current.mark(n15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.currentSting != this.markedString) {
                this.currentSting = this.markedString - 1;
                this.nextReader();
                this.current.skip(this.mark);
            } else {
                this.current.reset();
            }
            this.next = this.mark;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            int n15 = this.current.read();
            if (n15 < 0 && this.currentSting < this.strings.length) {
                this.nextReader();
                return this.read();
            }
            ++this.next;
            return n15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n15, int n16) throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            int n17 = this.current.read(cArray, n15, n16);
            if (n17 < 0 && this.currentSting < this.strings.length) {
                this.nextReader();
                return this.read(cArray, n15, n16);
            }
            this.next += (long)n17;
            return n17;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.current.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l15) throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            long l16 = this.current.skip(l15);
            if (l16 == 0L && this.currentSting < this.strings.length) {
                this.nextReader();
                return this.skip(l15);
            }
            this.next += l16;
            return l16;
        }
    }
}

