/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageMouseClickListener;
import hu.kazocsaba.imageviewer.ImageMouseEvent;
import hu.kazocsaba.imageviewer.ImageMouseMotionListener;
import hu.kazocsaba.imageviewer.ImageViewer;
import hu.kazocsaba.imageviewer.ResizeStrategy;
import java.applet.Applet;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

class ImageComponent
extends JComponent {
    private ResizeStrategy resizeStrategy = ResizeStrategy.SHRINK_TO_FIT;
    private BufferedImage image;
    private boolean pixelatedZoom = false;
    private Object interpolationType = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
    private double zoomFactor = 1.0;
    private final List<ImageMouseMotionListener> moveListeners = new ArrayList<ImageMouseMotionListener>(4);
    private final List<ImageMouseClickListener> clickListeners = new ArrayList<ImageMouseClickListener>(4);
    private final MouseEventTranslator mouseEventTranslator = new MouseEventTranslator();
    private final PaintManager paintManager = new PaintManager();
    private Rescroller rescroller = new Rescroller();
    private final PropertyChangeSupport propertyChangeSupport;
    private final ImageViewer viewer;

    public ImageComponent(ImageViewer viewer, PropertyChangeSupport propertyChangeSupport) {
        this.viewer = viewer;
        this.propertyChangeSupport = propertyChangeSupport;
        this.mouseEventTranslator.register(this);
        this.setOpaque(true);
        viewer.getScrollPane().getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e15) {
                if (ImageComponent.this.hasSize()) {
                    ImageComponent.this.mouseEventTranslator.correctionalFire();
                }
            }
        });
    }

    private boolean hasSize() {
        return this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addImageMouseMoveListener(ImageMouseMotionListener l15) {
        if (l15 != null) {
            this.moveListeners.add(l15);
        }
    }

    public void removeImageMouseMoveListener(ImageMouseMotionListener l15) {
        if (l15 != null) {
            this.moveListeners.remove(l15);
        }
    }

    public void addImageMouseClickListener(ImageMouseClickListener l15) {
        if (l15 != null) {
            this.clickListeners.add(l15);
        }
    }

    public void removeImageMouseClickListener(ImageMouseClickListener l15) {
        if (l15 != null) {
            this.clickListeners.remove(l15);
        }
    }

    public void setImage(BufferedImage newImage) {
        BufferedImage oldImage = this.image;
        this.image = newImage;
        this.paintManager.notifyChanged();
        if (oldImage != newImage && (oldImage == null || newImage == null || oldImage.getWidth() != newImage.getWidth() || oldImage.getHeight() != newImage.getHeight())) {
            this.revalidate();
        }
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("image", oldImage, newImage);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void resizeNow() {
        Container c15;
        this.invalidate();
        Container root = null;
        for (c15 = this; c15 != null; c15 = c15.getParent()) {
            if (!c15.isDisplayable() || c15 instanceof CellRendererPane) {
                return;
            }
            if (!c15.isValidateRoot()) continue;
            root = c15;
            break;
        }
        if (root == null) {
            return;
        }
        while (c15 != null) {
            if (!c15.isDisplayable() || !c15.isVisible()) {
                return;
            }
            if (c15 instanceof Window || c15 instanceof Applet) break;
            c15 = c15.getParent();
        }
        if (c15 == null) {
            return;
        }
        root.validate();
        this.repaint();
    }

    public void setResizeStrategy(ResizeStrategy resizeStrategy) {
        if (resizeStrategy == this.resizeStrategy) {
            return;
        }
        this.rescroller.prepare();
        ResizeStrategy oldResizeStrategy = this.resizeStrategy;
        this.resizeStrategy = resizeStrategy;
        boolean canRescroll = this.viewer.getSynchronizer().resizeStrategyChangedCanIRescroll(this.viewer);
        this.resizeNow();
        if (canRescroll) {
            this.rescroller.rescroll();
            this.viewer.getSynchronizer().doneRescrolling(this.viewer);
        }
        this.propertyChangeSupport.firePropertyChange("resizeStrategy", (Object)oldResizeStrategy, (Object)resizeStrategy);
    }

    public ResizeStrategy getResizeStrategy() {
        return this.resizeStrategy;
    }

    public void setInterpolationType(Object type) {
        if (this.interpolationType == type) {
            return;
        }
        if (type != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR && type != RenderingHints.VALUE_INTERPOLATION_BILINEAR && type != RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            throw new IllegalArgumentException("Invalid interpolation type; use one of the RenderingHints constants");
        }
        Object old = this.interpolationType;
        this.interpolationType = type;
        this.viewer.getSynchronizer().interpolationTypeChanged(this.viewer);
        this.paintManager.notifyChanged();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("interpolationType", old, type);
    }

    public Object getInterpolationType() {
        return this.interpolationType;
    }

    public void setPixelatedZoom(boolean pixelatedZoom) {
        if (pixelatedZoom == this.pixelatedZoom) {
            return;
        }
        this.pixelatedZoom = pixelatedZoom;
        this.viewer.getSynchronizer().pixelatedZoomChanged(this.viewer);
        this.paintManager.notifyChanged();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("pixelatedZoom", !pixelatedZoom, pixelatedZoom);
    }

    public boolean isPixelatedZoom() {
        return this.pixelatedZoom;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double newZoomFactor) {
        if (this.zoomFactor == newZoomFactor) {
            return;
        }
        if (newZoomFactor <= 0.0 || Double.isInfinite(newZoomFactor) || Double.isNaN(newZoomFactor)) {
            throw new IllegalArgumentException("Invalid zoom factor: " + newZoomFactor);
        }
        if (this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
            this.rescroller.prepare();
        }
        double oldZoomFactor = this.zoomFactor;
        this.zoomFactor = newZoomFactor;
        boolean canRescroll = this.viewer.getSynchronizer().zoomFactorChangedCanIRescroll(this.viewer);
        if (this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
            this.resizeNow();
            if (canRescroll) {
                this.rescroller.rescroll();
                this.viewer.getSynchronizer().doneRescrolling(this.viewer);
            }
        } else if (canRescroll) {
            this.viewer.getSynchronizer().doneRescrolling(this.viewer);
        }
        this.propertyChangeSupport.firePropertyChange("zoomFactor", oldZoomFactor, newZoomFactor);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension();
        }
        if (this.resizeStrategy == ResizeStrategy.CUSTOM_ZOOM) {
            return new Dimension((int)Math.ceil((double)this.image.getWidth() * this.zoomFactor), (int)Math.ceil((double)this.image.getHeight() * this.zoomFactor));
        }
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public Point pointToPixel(Point p15) {
        return this.pointToPixel(p15, true);
    }

    public Point pointToPixel(Point p15, boolean clipToImage) {
        Point2D.Double fp4 = new Point2D.Double((double)p15.x + 0.5, (double)p15.y + 0.5);
        try {
            this.getImageTransform().inverseTransform(fp4, fp4);
        }
        catch (NoninvertibleTransformException ex4) {
            throw new Error("Image transformation not invertible");
        }
        p15.x = (int)Math.floor(fp4.x);
        p15.y = (int)Math.floor(fp4.y);
        if (clipToImage && (p15.x < 0 || p15.y < 0 || p15.x >= this.image.getWidth() || p15.y >= this.image.getHeight())) {
            return null;
        }
        return p15;
    }

    @Override
    protected void paintComponent(Graphics g15) {
        this.paintManager.paintComponent(g15);
    }

    public AffineTransform getImageTransform() {
        double currentZoom;
        if (this.getImage() == null) {
            throw new IllegalStateException("No image");
        }
        if (!this.hasSize()) {
            throw new IllegalStateException("Viewer size is zero");
        }
        switch (this.resizeStrategy) {
            case NO_RESIZE: {
                currentZoom = 1.0;
                break;
            }
            case SHRINK_TO_FIT: {
                currentZoom = Math.min(this.getSizeRatio(), 1.0);
                break;
            }
            case RESIZE_TO_FIT: {
                currentZoom = this.getSizeRatio();
                break;
            }
            case CUSTOM_ZOOM: {
                currentZoom = this.zoomFactor;
                break;
            }
            default: {
                throw new Error("Unhandled resize strategy");
            }
        }
        AffineTransform tr4 = new AffineTransform();
        tr4.setToTranslation(((double)this.getWidth() - (double)this.image.getWidth() * currentZoom) / 2.0, ((double)this.getHeight() - (double)this.image.getHeight() * currentZoom) / 2.0);
        tr4.scale(currentZoom, currentZoom);
        return tr4;
    }

    private double getSizeRatio() {
        return Math.min((double)this.getWidth() / (double)this.image.getWidth(), (double)this.getHeight() / (double)this.image.getHeight());
    }

    private class PaintManager {
        BufferedImage cachedImage = null;
        boolean cachedImageChanged = false;
        AffineTransform cachedTransform;

        private PaintManager() {
        }

        private void doPaint(Graphics2D gg5, AffineTransform imageTransform) {
            gg5.setColor(ImageComponent.this.getBackground());
            gg5.fillRect(0, 0, ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
            gg5.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (ImageComponent.this.pixelatedZoom && imageTransform.getScaleX() >= 1.0) {
                gg5.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else {
                gg5.setRenderingHint(RenderingHints.KEY_INTERPOLATION, ImageComponent.this.interpolationType);
            }
            gg5.drawImage(ImageComponent.this.image, imageTransform, ImageComponent.this);
        }

        private void ensureCachedValid(AffineTransform imageTransform) {
            boolean cacheValid;
            if (this.cachedImage == null || this.cachedImage.getWidth() < ImageComponent.this.getWidth() || this.cachedImage.getHeight() < ImageComponent.this.getHeight()) {
                this.cachedImage = ImageComponent.this.getGraphicsConfiguration().createCompatibleImage(ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
                cacheValid = false;
            } else {
                boolean bl4 = cacheValid = this.cachedTransform.equals(imageTransform) && !this.cachedImageChanged;
            }
            if (!cacheValid) {
                Graphics2D gg5 = this.cachedImage.createGraphics();
                this.doPaint(gg5, imageTransform);
                gg5.dispose();
                this.cachedImageChanged = false;
                this.cachedTransform = new AffineTransform(imageTransform);
            }
        }

        public void notifyChanged() {
            this.cachedImageChanged = true;
        }

        public void paintComponent(Graphics g15) {
            if (ImageComponent.this.image == null) {
                Graphics2D gg5 = (Graphics2D)g15.create();
                gg5.setColor(ImageComponent.this.getBackground());
                gg5.fillRect(0, 0, ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
                gg5.dispose();
                return;
            }
            AffineTransform imageTransform = ImageComponent.this.getImageTransform();
            if (imageTransform.getScaleX() < 1.0 && ImageComponent.this.interpolationType != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                this.ensureCachedValid(imageTransform);
                g15.drawImage(this.cachedImage, 0, 0, ImageComponent.this);
            } else {
                Graphics2D gg6 = (Graphics2D)g15.create();
                this.doPaint(gg6, imageTransform);
                gg6.dispose();
            }
        }
    }

    private class MouseEventTranslator
    implements MouseInputListener,
    PropertyChangeListener {
        private boolean on = false;
        private Point lastPosition = null;

        private MouseEventTranslator() {
        }

        private void register(ImageComponent ic5) {
            ic5.addMouseListener(this);
            ic5.addMouseMotionListener(this);
            ic5.propertyChangeSupport.addPropertyChangeListener(this);
            ic5.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e15) {
                    MouseEventTranslator.this.correctionalFire();
                }
            });
        }

        private void handleMouseAt(Point position, MouseEvent event) {
            if (ImageComponent.this.image == null) {
                if (this.on) {
                    this.on = false;
                    this.fireMouseExit();
                }
            } else {
                if (position != null) {
                    position = ImageComponent.this.pointToPixel(position);
                }
                if (position == null) {
                    if (this.on) {
                        this.on = false;
                        this.fireMouseExit();
                    }
                } else {
                    if (!this.on) {
                        this.on = true;
                        this.lastPosition = null;
                        this.fireMouseEnter(position.x, position.y, event);
                    }
                    if (!position.equals(this.lastPosition)) {
                        this.lastPosition = position;
                        this.fireMouseAtPixel(position.x, position.y, event);
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e15) {
            if (ImageComponent.this.image == null || !this.on) {
                return;
            }
            Point p15 = ImageComponent.this.pointToPixel(e15.getPoint());
            if (p15 != null) {
                this.fireMouseClickedAtPixel(p15.x, p15.y, e15);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e15) {
            Point p15;
            if (ImageComponent.this.image != null && (p15 = ImageComponent.this.pointToPixel(e15.getPoint())) != null) {
                this.on = true;
                this.fireMouseEnter(p15.x, p15.y, e15);
                this.fireMouseAtPixel(p15.x, p15.y, e15);
            }
        }

        @Override
        public void mouseExited(MouseEvent e15) {
            if (this.on) {
                this.on = false;
                this.fireMouseExit();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e15) {
            this.handleMouseAt(e15.getPoint(), e15);
        }

        @Override
        public void mouseDragged(MouseEvent e15) {
            if (ImageComponent.this.image == null) {
                return;
            }
            Point p15 = ImageComponent.this.pointToPixel(e15.getPoint(), false);
            this.fireMouseDrag(p15.x, p15.y, e15);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("image".equals(evt.getPropertyName()) || "resizeStrategy".equals(evt.getPropertyName()) || ImageComponent.this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM && "zoomFactor".equals(evt.getPropertyName())) {
                this.correctionalFire();
            }
        }

        private void correctionalFire() {
            this.handleMouseAt(ImageComponent.this.getParent().getMousePosition(true), null);
        }

        private void fireMouseAtPixel(int x15, int y15, MouseEvent ev4) {
            ImageMouseEvent e15 = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e15 == null) {
                    e15 = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x15, y15, ev4);
                }
                imageMouseMoveListener.mouseMoved(e15);
            }
        }

        private void fireMouseClickedAtPixel(int x15, int y15, MouseEvent ev4) {
            ImageMouseEvent e15 = null;
            for (ImageMouseClickListener imageMouseClickListener : ImageComponent.this.clickListeners) {
                if (e15 == null) {
                    e15 = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x15, y15, ev4);
                }
                imageMouseClickListener.mouseClicked(e15);
            }
        }

        private void fireMouseEnter(int x15, int y15, MouseEvent ev4) {
            ImageMouseEvent e15 = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e15 == null) {
                    e15 = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x15, y15, ev4);
                }
                imageMouseMoveListener.mouseEntered(e15);
            }
        }

        private void fireMouseExit() {
            ImageMouseEvent e15 = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e15 == null) {
                    e15 = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, -1, -1, null);
                }
                imageMouseMoveListener.mouseExited(e15);
            }
        }

        private void fireMouseDrag(int x15, int y15, MouseEvent ev4) {
            ImageMouseEvent e15 = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e15 == null) {
                    e15 = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x15, y15, ev4);
                }
                imageMouseMoveListener.mouseDragged(e15);
            }
        }

        @Override
        public void mousePressed(MouseEvent e15) {
        }

        @Override
        public void mouseReleased(MouseEvent e15) {
        }
    }

    class Rescroller {
        private Point2D preparedCenter = null;

        Rescroller() {
        }

        void prepare() {
            if (ImageComponent.this.image != null && ImageComponent.this.hasSize()) {
                Rectangle viewRect = ImageComponent.this.viewer.getScrollPane().getViewport().getViewRect();
                this.preparedCenter = new Point2D.Double(viewRect.getCenterX(), viewRect.getCenterY());
                try {
                    ImageComponent.this.getImageTransform().inverseTransform(this.preparedCenter, this.preparedCenter);
                }
                catch (NoninvertibleTransformException e15) {
                    throw new Error(e15);
                }
            }
        }

        void rescroll() {
            if (this.preparedCenter != null) {
                Dimension viewSize = ImageComponent.this.viewer.getScrollPane().getViewport().getExtentSize();
                ImageComponent.this.getImageTransform().transform(this.preparedCenter, this.preparedCenter);
                Rectangle view = new Rectangle((int)Math.round(this.preparedCenter.getX() - (double)viewSize.width / 2.0), (int)Math.round(this.preparedCenter.getY() - (double)viewSize.height / 2.0), viewSize.width, viewSize.height);
                this.preparedCenter = null;
                ImageComponent.this.scrollRectToVisible(view);
            }
        }
    }
}

