/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.observers.LambdaConsumerIntrospection;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractDisposableAutoRelease
extends AtomicReference<Disposable>
implements Disposable,
LambdaConsumerIntrospection {
    private static final long serialVersionUID = 8924480688481408726L;
    final AtomicReference<DisposableContainer> composite;
    final Consumer<? super Throwable> onError;
    final Action onComplete;

    AbstractDisposableAutoRelease(DisposableContainer composite, Consumer<? super Throwable> onError, Action onComplete) {
        this.onError = onError;
        this.onComplete = onComplete;
        this.composite = new AtomicReference<DisposableContainer>(composite);
    }

    public final void onError(Throwable t15) {
        if (this.get() != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onError.accept(t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(new CompositeException(t15, e15));
            }
        } else {
            RxJavaPlugins.onError(t15);
        }
        this.removeSelf();
    }

    public final void onComplete() {
        if (this.get() != DisposableHelper.DISPOSED) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(e15);
            }
        }
        this.removeSelf();
    }

    @Override
    public final void dispose() {
        DisposableHelper.dispose(this);
        this.removeSelf();
    }

    final void removeSelf() {
        DisposableContainer c15 = this.composite.getAndSet(null);
        if (c15 != null) {
            c15.delete(this);
        }
    }

    @Override
    public final boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    public final void onSubscribe(Disposable d15) {
        DisposableHelper.setOnce(this, d15);
    }

    @Override
    public final boolean hasCustomOnError() {
        return this.onError != Functions.ON_ERROR_MISSING;
    }
}

