/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.subscribers.DisposableSubscriber;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.Collection;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractFlowableWithUpstream<T, U> {
    final Publisher<B> boundary;
    final Supplier<U> bufferSupplier;

    public FlowableBufferExactBoundary(Flowable<T> source, Publisher<B> boundary, Supplier<U> bufferSupplier) {
        super(source);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s15) {
        this.source.subscribe(new BufferExactBoundarySubscriber(new SerializedSubscriber<U>(s15), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableSubscriber<B> {
        final BufferExactBoundarySubscriber<T, U, B> parent;

        BufferBoundarySubscriber(BufferExactBoundarySubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t15) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.onError(t15);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Disposable {
        final Supplier<U> bufferSupplier;
        final Publisher<B> boundary;
        Subscription upstream;
        Disposable other;
        U buffer;

        BufferExactBoundarySubscriber(Subscriber<? super U> actual, Supplier<U> bufferSupplier, Publisher<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            BufferBoundarySubscriber bs4;
            Collection b15;
            if (!SubscriptionHelper.validate(this.upstream, s15)) {
                return;
            }
            this.upstream = s15;
            try {
                b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.cancelled = true;
                s15.cancel();
                EmptySubscription.error(e15, this.downstream);
                return;
            }
            this.buffer = b15;
            this.other = bs4 = new BufferBoundarySubscriber(this);
            this.downstream.onSubscribe(this);
            if (!this.cancelled) {
                s15.request(Long.MAX_VALUE);
                this.boundary.subscribe(bs4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                U b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                b15.add(t15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.cancel();
            this.downstream.onError(t15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b15;
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b15);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void request(long n15) {
            this.requested(n15);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.upstream.cancel();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b15;
            Collection next;
            try {
                next = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.cancel();
                this.downstream.onError(e15);
                return;
            }
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmitMax(b15, false, this);
        }

        @Override
        public void dispose() {
            this.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public boolean accept(Subscriber<? super U> a15, U v15) {
            this.downstream.onNext(v15);
            return true;
        }
    }
}

