/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSampleTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;
    final Consumer<? super T> onDropped;

    public FlowableSampleTimed(Flowable<T> source, long period, TimeUnit unit, Scheduler scheduler, boolean emitLast, Consumer<? super T> onDropped) {
        super(source);
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(s15);
        if (this.emitLast) {
            this.source.subscribe(new SampleTimedEmitLast<T>(serial, this.period, this.unit, this.scheduler, this.onDropped));
        } else {
            this.source.subscribe(new SampleTimedNoLast<T>(serial, this.period, this.unit, this.scheduler, this.onDropped));
        }
    }

    static final class SampleTimedEmitLast<T>
    extends SampleTimedSubscriber<T> {
        private static final long serialVersionUID = -7139995637533111443L;
        final AtomicInteger wip = new AtomicInteger(1);

        SampleTimedEmitLast(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
            super(actual, period, unit, scheduler, onDropped);
        }

        @Override
        void complete() {
            this.emit();
            if (this.wip.decrementAndGet() == 0) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void run() {
            if (this.wip.incrementAndGet() == 2) {
                this.emit();
                if (this.wip.decrementAndGet() == 0) {
                    this.downstream.onComplete();
                }
            }
        }
    }

    static final class SampleTimedNoLast<T>
    extends SampleTimedSubscriber<T> {
        private static final long serialVersionUID = -7139995637533111443L;

        SampleTimedNoLast(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
            super(actual, period, unit, scheduler, onDropped);
        }

        @Override
        void complete() {
            this.downstream.onComplete();
        }

        @Override
        public void run() {
            this.emit();
        }
    }

    static abstract class SampleTimedSubscriber<T>
    extends AtomicReference<T>
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Subscriber<? super T> downstream;
        final long period;
        final TimeUnit unit;
        final Scheduler scheduler;
        final Consumer<? super T> onDropped;
        final AtomicLong requested = new AtomicLong();
        final SequentialDisposable timer = new SequentialDisposable();
        Subscription upstream;

        SampleTimedSubscriber(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                this.timer.replace(this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit));
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            T oldValue = this.getAndSet(t15);
            if (oldValue != null && this.onDropped != null) {
                try {
                    this.onDropped.accept(oldValue);
                }
                catch (Throwable throwable) {
                    Exceptions.throwIfFatal(throwable);
                    this.cancelTimer();
                    this.upstream.cancel();
                    this.downstream.onError(throwable);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.cancelTimer();
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.cancelTimer();
            this.complete();
        }

        void cancelTimer() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
            }
        }

        @Override
        public void cancel() {
            this.cancelTimer();
            this.upstream.cancel();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r15 = this.requested.get();
                if (r15 != 0L) {
                    this.downstream.onNext(value);
                    BackpressureHelper.produced(this.requested, 1L);
                } else {
                    this.cancel();
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }

        abstract void complete();
    }
}

