/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.ScalarSubscription;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableScalarXMap {
    private FlowableScalarXMap() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, R> boolean tryScalarXMapSubscribe(Publisher<T> source, Subscriber<? super R> subscriber, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        if (source instanceof Supplier) {
            Publisher<R> r15;
            Object t15;
            try {
                t15 = ((Supplier)((Object)source)).get();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptySubscription.error(ex4, subscriber);
                return true;
            }
            if (t15 == null) {
                EmptySubscription.complete(subscriber);
                return true;
            }
            try {
                r15 = Objects.requireNonNull(mapper.apply(t15), "The mapper returned a null Publisher");
            }
            catch (Throwable ex5) {
                Exceptions.throwIfFatal(ex5);
                EmptySubscription.error(ex5, subscriber);
                return true;
            }
            if (r15 instanceof Supplier) {
                Object u15;
                try {
                    u15 = ((Supplier)((Object)r15)).get();
                }
                catch (Throwable ex6) {
                    Exceptions.throwIfFatal(ex6);
                    EmptySubscription.error(ex6, subscriber);
                    return true;
                }
                if (u15 == null) {
                    EmptySubscription.complete(subscriber);
                    return true;
                }
                subscriber.onSubscribe(new ScalarSubscription<R>(subscriber, u15));
            } else {
                r15.subscribe(subscriber);
            }
            return true;
        }
        return false;
    }

    public static <T, U> Flowable<U> scalarXMap(T value, Function<? super T, ? extends Publisher<? extends U>> mapper) {
        return RxJavaPlugins.onAssembly(new ScalarXMapFlowable(value, mapper));
    }

    static final class ScalarXMapFlowable<T, R>
    extends Flowable<R> {
        final T value;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;

        ScalarXMapFlowable(T value, Function<? super T, ? extends Publisher<? extends R>> mapper) {
            this.value = value;
            this.mapper = mapper;
        }

        @Override
        public void subscribeActual(Subscriber<? super R> s15) {
            Publisher<R> other;
            try {
                other = Objects.requireNonNull(this.mapper.apply(this.value), "The mapper returned a null Publisher");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                EmptySubscription.error(e15, s15);
                return;
            }
            if (other instanceof Supplier) {
                Object u15;
                try {
                    u15 = ((Supplier)((Object)other)).get();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    EmptySubscription.error(ex4, s15);
                    return;
                }
                if (u15 == null) {
                    EmptySubscription.complete(s15);
                    return;
                }
                s15.onSubscribe(new ScalarSubscription<R>(s15, u15));
            } else {
                other.subscribe(s15);
            }
        }
    }
}

