/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.observers.BasicFuseableObserver;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.Objects;

public final class ObservableMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends U> function;

    public ObservableMap(ObservableSource<T> source, Function<? super T, ? extends U> function) {
        super(source);
        this.function = function;
    }

    @Override
    public void subscribeActual(Observer<? super U> t15) {
        this.source.subscribe(new MapObserver<T, U>(t15, this.function));
    }

    static final class MapObserver<T, U>
    extends BasicFuseableObserver<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapObserver(Observer<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t15) {
            U v15;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper function returned a null value.");
            }
            catch (Throwable ex4) {
                this.fail(ex4);
                return;
            }
            this.downstream.onNext(v15);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Throwable {
            Object t15 = this.qd.poll();
            return t15 != null ? (U)Objects.requireNonNull(this.mapper.apply(t15), "The mapper function returned a null value.") : null;
        }
    }
}

