/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.schedulers.TrampolineScheduler;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableObserveOn<T>
extends AbstractObservableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean delayError;
    final int bufferSize;

    public ObservableObserveOn(ObservableSource<T> source, Scheduler scheduler, boolean delayError, int bufferSize) {
        super(source);
        this.scheduler = scheduler;
        this.delayError = delayError;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        if (this.scheduler instanceof TrampolineScheduler) {
            this.source.subscribe(observer);
        } else {
            Scheduler.Worker w15 = this.scheduler.createWorker();
            this.source.subscribe(new ObserveOnObserver<T>(observer, w15, this.delayError, this.bufferSize));
        }
    }

    static final class ObserveOnObserver<T>
    extends BasicIntQueueDisposable<T>
    implements Observer<T>,
    Runnable {
        private static final long serialVersionUID = 6576896619930983584L;
        final Observer<? super T> downstream;
        final Scheduler.Worker worker;
        final boolean delayError;
        final int bufferSize;
        SimpleQueue<T> queue;
        Disposable upstream;
        Throwable error;
        volatile boolean done;
        volatile boolean disposed;
        int sourceMode;
        boolean outputFused;

        ObserveOnObserver(Observer<? super T> actual, Scheduler.Worker worker, boolean delayError, int bufferSize) {
            this.downstream = actual;
            this.worker = worker;
            this.delayError = delayError;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                if (d15 instanceof QueueDisposable) {
                    QueueDisposable qd5 = (QueueDisposable)d15;
                    int m15 = qd5.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = qd5;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.schedule();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = qd5;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 2) {
                this.queue.offer(t15);
            }
            this.schedule();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.error = t15;
            this.done = true;
            this.schedule();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.schedule();
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.upstream.dispose();
                this.worker.dispose();
                if (!this.outputFused && this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }

        void drainNormal() {
            int missed = 1;
            SimpleQueue<T> q15 = this.queue;
            Observer<T> a15 = this.downstream;
            block2: do {
                if (this.checkTerminated(this.done, q15.isEmpty(), a15)) {
                    return;
                }
                while (true) {
                    boolean empty;
                    T v15;
                    boolean d15 = this.done;
                    try {
                        v15 = q15.poll();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.disposed = true;
                        this.upstream.dispose();
                        q15.clear();
                        a15.onError(ex4);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl4 = empty = v15 == null;
                    if (this.checkTerminated(d15, empty, a15)) {
                        return;
                    }
                    if (empty) continue block2;
                    a15.onNext(v15);
                }
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drainFused() {
            int missed = 1;
            do {
                if (this.disposed) {
                    return;
                }
                boolean d15 = this.done;
                Throwable ex4 = this.error;
                if (!this.delayError && d15 && ex4 != null) {
                    this.disposed = true;
                    this.downstream.onError(this.error);
                    this.worker.dispose();
                    return;
                }
                this.downstream.onNext(null);
                if (!d15) continue;
                this.disposed = true;
                ex4 = this.error;
                if (ex4 != null) {
                    this.downstream.onError(ex4);
                } else {
                    this.downstream.onComplete();
                }
                this.worker.dispose();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        public void run() {
            if (this.outputFused) {
                this.drainFused();
            } else {
                this.drainNormal();
            }
        }

        boolean checkTerminated(boolean d15, boolean empty, Observer<? super T> a15) {
            if (this.disposed) {
                this.queue.clear();
                return true;
            }
            if (d15) {
                Throwable e15 = this.error;
                if (this.delayError) {
                    if (empty) {
                        this.disposed = true;
                        if (e15 != null) {
                            a15.onError(e15);
                        } else {
                            a15.onComplete();
                        }
                        this.worker.dispose();
                        return true;
                    }
                } else {
                    if (e15 != null) {
                        this.disposed = true;
                        this.queue.clear();
                        a15.onError(e15);
                        this.worker.dispose();
                        return true;
                    }
                    if (empty) {
                        this.disposed = true;
                        a15.onComplete();
                        this.worker.dispose();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            return this.queue.poll();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

