/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelFilter<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Predicate<? super T> predicate;

    public ParallelFilter(ParallelFlowable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n15 = subscribers.length;
        Subscriber[] parents = new Subscriber[n15];
        for (int i15 = 0; i15 < n15; ++i15) {
            Subscriber<? super T> a15 = subscribers[i15];
            parents[i15] = a15 instanceof ConditionalSubscriber ? new ParallelFilterConditionalSubscriber<T>((ConditionalSubscriber)a15, this.predicate) : new ParallelFilterSubscriber<T>(a15, this.predicate);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelFilterConditionalSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final ConditionalSubscriber<? super T> downstream;

        ParallelFilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate) {
            super(predicate);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            if (!this.done) {
                boolean b15;
                try {
                    b15 = this.predicate.test(t15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.cancel();
                    this.onError(ex4);
                    return false;
                }
                if (b15) {
                    return this.downstream.tryOnNext(t15);
                }
            }
            return false;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }
    }

    static final class ParallelFilterSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final Subscriber<? super T> downstream;

        ParallelFilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate) {
            super(predicate);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            if (!this.done) {
                boolean b15;
                try {
                    b15 = this.predicate.test(t15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.cancel();
                    this.onError(ex4);
                    return false;
                }
                if (b15) {
                    this.downstream.onNext(t15);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }
    }

    static abstract class BaseFilterSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Predicate<? super T> predicate;
        Subscription upstream;
        boolean done;

        BaseFilterSubscriber(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public final void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public final void cancel() {
            this.upstream.cancel();
        }

        @Override
        public final void onNext(T t15) {
            if (!this.tryOnNext(t15) && !this.done) {
                this.upstream.request(1L);
            }
        }
    }
}

