/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableSubject
extends Completable
implements CompletableObserver {
    final AtomicReference<CompletableDisposable[]> observers;
    static final CompletableDisposable[] EMPTY = new CompletableDisposable[0];
    static final CompletableDisposable[] TERMINATED = new CompletableDisposable[0];
    final AtomicBoolean once = new AtomicBoolean();
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static CompletableSubject create() {
        return new CompletableSubject();
    }

    CompletableSubject() {
        this.observers = new AtomicReference<CompletableDisposable[]>(EMPTY);
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (this.observers.get() == TERMINATED) {
            d15.dispose();
        }
    }

    @Override
    public void onError(Throwable e15) {
        ExceptionHelper.nullCheck(e15, "onError called with a null Throwable.");
        if (this.once.compareAndSet(false, true)) {
            this.error = e15;
            for (CompletableDisposable md5 : this.observers.getAndSet(TERMINATED)) {
                md5.downstream.onError(e15);
            }
        } else {
            RxJavaPlugins.onError(e15);
        }
    }

    @Override
    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            for (CompletableDisposable md5 : this.observers.getAndSet(TERMINATED)) {
                md5.downstream.onComplete();
            }
        }
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        CompletableDisposable md5 = new CompletableDisposable(observer, this);
        observer.onSubscribe(md5);
        if (this.add(md5)) {
            if (md5.isDisposed()) {
                this.remove(md5);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                observer.onError(ex4);
            } else {
                observer.onComplete();
            }
        }
    }

    boolean add(CompletableDisposable inner) {
        CompletableDisposable[] b15;
        CompletableDisposable[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new CompletableDisposable[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = inner;
        } while (!this.observers.compareAndSet(a15, b15));
        return true;
    }

    void remove(CompletableDisposable inner) {
        CompletableDisposable[] b15;
        CompletableDisposable[] a15;
        do {
            int n15;
            if ((n15 = (a15 = this.observers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != inner) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new CompletableDisposable[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.observers.compareAndSet(a15, b15));
    }

    @Nullable
    public Throwable getThrowable() {
        if (this.observers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    public boolean hasThrowable() {
        return this.observers.get() == TERMINATED && this.error != null;
    }

    public boolean hasComplete() {
        return this.observers.get() == TERMINATED && this.error == null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    static final class CompletableDisposable
    extends AtomicReference<CompletableSubject>
    implements Disposable {
        private static final long serialVersionUID = -7650903191002190468L;
        final CompletableObserver downstream;

        CompletableDisposable(CompletableObserver actual, CompletableSubject parent) {
            this.downstream = actual;
            this.lazySet(parent);
        }

        @Override
        public void dispose() {
            CompletableSubject parent = this.getAndSet(null);
            if (parent != null) {
                parent.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

